<?php

namespace Bloom\Cms\UserModule\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ResetPassword extends Mailable
{
    use Queueable, SerializesModels;

    public $count;
    public $url;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($url, $count)
    {
        $this->url = $url;
        $this->count = $count;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('UserModule::mail.mail_reset_password')
            ->from(config("mail.from"), config("mail.name"))
            ->subject('Nouveau mot de passe');

    }
}
