<?php

namespace Bloom\Cms\UserModule\Http\Controllers;


use Bloom\Cms\UserModule\Data\User;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Validator;
use Illuminate\View\View;


class ResetPasswordController extends Controller
{

    /**
     * Display the password reset view for the given token.
     *
     * If no token is present, display the link request form.
     *
     * @param Request     $request
     * @param string|null $token
     *
     * @return Factory|View|Response
     */
    public function showResetForm(Request $request, $token = null)
    {
        return view('UserModule::auth.passwords.reset')->with(
            ['token' => $token, 'email' => $request->email]
        );
    }

    /**
     * Display the form to request a password reset link.
     *
     * @return Response|Factory|View
     */
    public function showLinkRequestForm()
    {
        return view('UserModule::auth.passwords.email');
    }

    public function new_mdp_save(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email'                 => 'required|email:rfc,dns',
            'password'              => 'required',
            'password_confirmation' => 'required'
        ]);
        if ($validator->fails()) {
            return back()
                ->withInput(request()->all())
                ->withErrors($validator);
        } else {
            User::where('email', $request->email)->update(['password_save' => true]);
            $a = new Auth\ResetPasswordController();

            return $a->reset($request);
        }
    }
}

