<?php

namespace Bloom\Cms\UserModule\Data;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Groupe
 * @package Bloom\Cms\Authentification\Data
 *
 *  En base
 * @property int    $id
 * @property string $nom
 * @property Carbon $created_at
 * @property Carbon $updated_at
 */
class Groupe extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function auths()
    {
        return $this->belongsToMany(
            Autorisation::class,
            'groupe_autorisations',
            'groupes_id',
            'autorisations_id'
        )->withPivot(['created_at', 'updated_at']);
    }

    public function userGroup()
    {
        return $this->belongsToMany(
            User::class,
            'user_groupes',
            'groupes_id',
            'user_id'
        )->withPivot(['created_at', 'updated_at']);
    }
}
