<?php

use Bloom\CMS\Modules\Architecture\Model\Module;
use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class AutorisationTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (Schema::hasTable('modules')) {
            $modules = DB::table("modules")->where("nom", "user")->first();
            if ($modules != null) {

                DB::table('autorisations')->insert([
                    [
                        'code' => 'USERS_LIST',
                        'module' => $modules->id,
                        'nom' => 'USERS_LIST',
                        'description' => 'a le droit de voir la liste des utilisateurs',
                        'created_at' => Carbon::now(),
                        'updated_at' => Carbon::now(),
                    ],
                    [
                        'code' => 'USERS_EDIT',
                        'module' => $modules->id,
                        'nom' => 'USERS_EDIT',
                        'description' => 'a le droit modifier le nom, email et groupes de l\'utilisateur',
                        'created_at' => Carbon::now(),
                        'updated_at' => Carbon::now(),
                    ],
                    [
                        'code' => 'USERS_DELETE',
                        'module' => $modules->id,
                        'nom' => 'USERS_DELETE',
                        'description' => 'a le droit de supprimer un utilisateur',
                        'created_at' => Carbon::now(),
                        'updated_at' => Carbon::now(),
                    ],
                    [
                        'code' => 'USERS_CREATE',
                        'module' => $modules->id,
                        'nom' => 'USERS_CREATE',
                        'description' => 'a le droit de créer un utilisateur',
                        'created_at' => Carbon::now(),
                        'updated_at' => Carbon::now(),
                    ],
                    [
                        'code' => 'USERS_G_CREATE',
                        'module' => $modules->id,
                        'nom' => 'USERS_G_CREATE',
                        'description' => 'a le droit de créer un groupe',
                        'created_at' => Carbon::now(),
                        'updated_at' => Carbon::now(),
                    ],
                    [
                        'code' => 'USERS_G_EDIT',
                        'module' => $modules->id,
                        'nom' => 'USERS_G_EDIT',
                        'description' => 'a le droit de modifier un groupe',
                        'created_at' => Carbon::now(),
                        'updated_at' => Carbon::now(),
                    ],
                    [
                        'code' => 'USERS_G_DELETE',
                        'module' => $modules->id,
                        'nom' => 'USERS_G_DELETE',
                        'description' => 'a le droit de supprimer un groupe',
                        'created_at' => Carbon::now(),
                        'updated_at' => Carbon::now(),
                    ],
                    [
                        'code' => 'USERS_G_LIST',
                        'module' => $modules->id,
                        'nom' => 'USERS_G_LIST',
                        'description' => 'a le droit de voir la liste des groupes',
                        'created_at' => Carbon::now(),
                        'updated_at' => Carbon::now(),
                    ]
                ]);
            }
        }
    }
}
