<?php

namespace Bloom\Cms\UserModule\Http\Controllers;

use Bloom\CMS\Core\Framework\Module;
use Bloom\Cms\UserModule\Data\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

/**
 * Class IdentificationController
 * @package Bloom\Cms\UserModule\Http\Controllers
 */
class IdentificationController extends Controller
{
    public function identificationSubmit(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email'    => 'required|email:rfc',
            'password' => 'required',
        ]);
        if ($validator->fails()) {
            return back()
                ->withInput(request()->all())
                ->withErrors($validator);
        } else {
            $email = request('email');
            $verifUser = User::query()->where('email', $email)->count();

            if ($verifUser == 1) {
                $resultat = auth()->attempt([
                    'email'    => request('email'),
                    'password' => request('password'),
                ]);

                if ($resultat) {
                    Session::flash('message', 'Vous êtes connecté');

                    return redirect()->route(Module::actif()->where('route', '!=', '')->first()->route);
                } else {
                    Session::flash('error', 'Le mail ou le mot de passe ne sont pas correct');

                    return back()->withInput();
                }
            } else {
                Session::flash('error', 'Le mail ou le mot de passe ne sont pas correct');

                return back()->withInput();
            }
        }
    }

    public function deconnexion()
    {
        auth()->logout();
        Session::flash('message', 'Vous êtes déconnecté');

        return redirect('/');
    }
}
