<?php

namespace Tests\Unit;

use Bloom\CMS\Core\Test;
use Bloom\Cms\UserModule\CmsUserModuleProvider;
use Bloom\Cms\UserModule\Data\User;
use Illuminate\Support\Facades\Hash;


class IdentificationTest extends Test
{
    protected $provider = CmsUserModuleProvider::class;

    /**
     * @test
     */
    public function user_can_view_a_login_form()
    {

        $response = $this->get(route('identification'));
        $response->assertSuccessful();
        $response->assertViewIs('Authentification::bloom.connexion.connexion');
    }

    /**
     * @test
     */
    public function user_cannot_login_with_incorrect_password()
    {
        $user = factory(User::class)->create([
            'password' => Hash::make('hello'),
        ]);

        $response = $this->post(route('identification_submit'), [
            'email'    => $user->email,
            'password' => 'invalid-password',
        ]);

        $response->assertRedirect('/');
        $this->assertTrue(session()->hasOldInput());
        $this->assertGuest();
    }

    /**
     * @test
     */
    public function user_login_correct()
    {
        $user = factory(User::class)->create([
            'password' => Hash::make('toto')
        ]);

        $response = $this->post(route('identification_submit'), [
            'email'    => $user->email,
            'password' => 'toto',
        ]);
        $this->assertEquals('Vous êtes connecté', session('message'));
        $response->assertRedirect('/');

        $this->assertAuthenticatedAs($user);

    }

    /**
     * @test
     */
    public function user_sign_out()
    {
        $user = factory(User::class)->create([
            'password' => Hash::make('toto')
        ]);

        $this->post(route('identification_submit'), [
            'email'    => $user->email,
            'password' => 'toto',
        ]);
        $this->get(route('deconnexion'));
        $this->assertGuest();

    }

}
