<?php

namespace Bloom\Cms\UserModule\Actions;

use App\User;
use Bloom\Cms\Sites\Helpers\SiteHelper;
use Illuminate\Support\Facades\Auth;

class ShouldUserBeRedirectedToOwnedSite
{
    private $user;
    private $auth;
    private $serviceid;

    public function __construct(User $user, string $auth = null, string $serviceid = null)
    {
        $this->user = $user;
        $this->auth = $auth;
        $this->serviceid = $serviceid;
    }

    public function execute()
    {
        $sites = SiteHelper::getUserAllowedSites($this->user);
        if(empty($sites) || count($sites) === 0){
            return false;
        }
        $current = SiteHelper::getCurrentSite();
        // Si il est super admin on valorise a vrai pour ne pas rediriger
        $found = $this->user->super_admin == 1;
        foreach ($sites as $site) {
            if ($site->id == $current->id) {
                $found = true;
                break;
            }
        }
        if (!$found) {
            Auth::logout();
            $url = request()->getScheme() . '://' . $sites->first()->domaine_prive . '/login';
            if($this->auth) {
                $url .= sprintf('?auth=%s&serviceid=%s', $this->auth, $this->serviceid);
            }
            return redirect($url);
        }

        return false;
    }
}
