@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit')

@section('content')
    @if(!empty(session('message')))
        <div class="alert alert-success alert-block">
            {{ session('message') }}
        </div>
    @endif
    @if(!empty(session('error')))
        <div class="alert alert-danger alert-block">
            {{ session('error') }}
        </div>
    @endif
    @if($errors->first('nom'))
        <div class="alert alert-danger alert-block">
            {{ $errors->first('nom') }}
        </div>
    @endif
    @if($errors->first('code'))
        <div class="alert alert-danger alert-block">
            {{ $errors->first('code') }}
        </div>
    @endif

    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>{{ $groupe->exists ? 'Éditer' : 'Créer' }} un groupe</h1>

            <span class="wrapper-btns ml-auto">
				<a href="{{ route('admin_user_group_index') }}" class="btn-annuler btn btn-grisclair5 btn-primary">
					Annuler
				</a>
				<a href="javascript:void(0);" class="btn-valider submit btn btn-grisclair5 btn-primary"
                   onclick="$('.main form').submit()">
					@if($groupe->exists)
                        Modifier
                    @else
                        Valider
                    @endif
                </a>
			</span>
        </div>

        <div class="content">
            <form method="post" id="form" action="{{ route('admin_user_group_save', $groupe) }}">
                {{ csrf_field() }}

                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="nom"
                                text="Nom"
                                :value="$groupe->exists ? $groupe->nom : old('nom')"
                                form="admin"
                                :required="true"
                        />
                    </div>
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="code"
                                text="Code"
                                :value="$groupe->exists ? $groupe->code : old('code')"
                                form="admin"
                                :required="true"
                        />
                    </div>
                </div>

                @if(isset($autorisations) && count($autorisations) > 0)
                    <div class="form-group row mb-0">
                        <div class="col-6 mb-4">
                            <label class="control-label">Autorisations</label>
                            <div class="checkboxes-inline-wrapper">
                                @foreach($autorisations as $autorisation)
                                    @php($checked = false)
                                    @foreach($groupe_autorisations as $groupe_autorisation)
                                        @if($groupe_autorisation === $autorisation->id)
                                            @php($checked = true)
                                        @endif
                                    @endforeach
                                    <x-forms.input-custom-checkbox
                                        :name="'autorisations[' . $autorisation->code . ']'"
                                        :text="$autorisation->nom"
                                        :value="$autorisation->id"
                                        form="admin"
                                        :inline="true"
                                        :checked="$checked"
                                    />
                                @endforeach
                            </div>
                        </div>
                    </div>
                @endif
            </form>
        </div>
    </div>
@endsection
