<?php


namespace Bloom\Cms\UserModule\Data;

use Bloom\Cms\Sites\Models\GroupeSite;
use Bloom\Cms\Sites\Models\Site;
use Bloom\Cms\UserModule\Notifications\PasswordReset;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Notifications\Notifiable;

/**
 * Class User
 * @package Bloom\Cms\Authentification\Data
 *
 * @property UserGroupe[]|Collection groupes
 * @property SiteUsers[]|Collection  sites
 * @property bool                    super_admin
 * @property string                  email
 * @property string                  boss_id
 * @property string                  password
 * @property string                  name
 * @property int                     groupe_site_id
 */
class User extends \Illuminate\Foundation\Auth\User
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password', 'boss_id', 'groupe_site_id'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function groupes()
    {

        return $this->belongsToMany(Groupe::class, 'user_groupes', 'user_id', 'groupes_id')->withPivot(['created_at', 'updated_at']);

    }

    public function boss(): BelongsTo
    {
        return $this->belongsTo(User::class, 'boss_id');
    }

    public function utilisateurs(): HasMany
    {
        return $this->hasMany(User::class, 'boss_id');
    }

    public function sites()
    {
        return $this->belongsToMany(Site::class, 'site_users', 'user_id', 'sites_id')->withPivot(['created_at', 'updated_at']);
    }

    public function sendPasswordResetNotification($token)
    {
        $this->notify(new PasswordReset($token));
    }

    public function getAccessLevel(): int
    {
        if ($this->super_admin) {
            return 1;
        }
        if ($this->boss_id === null) {
            return 2;
        }

        return 9;
    }

    public function groupe_site(): BelongsTo
    {
        return $this->belongsTo(GroupeSite::class, 'groupe_site_id');
    }
}
