<?php

namespace Bloom\Cms\UserModule\Data;

use Bloom\CMS\Core\Framework\Module;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Class Autorisation
 * @package Bloom\Cms\Authentification\Data
 *
 *   En base
 * @property int $id
 * @property string $code
 * @property int $module_id
 * @property string $nom
 * @property string $description
 * @property Carbon $created_at
 * @property Carbon $updated_at
 */
class Autorisation extends Model
{
    protected $fillable = [];
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function module(): BelongsTo
    {
        return $this->belongsTo(Module::class);
    }

    public function groupeAutorisation()
    {
        return $this->belongsToMany(
            Groupe::class,
            'groupe_autorisations',
            'autorisations_id',
            'groupes_id'
        )->withPivot(['created_at', 'updated_at']);
    }
}
