@extends('bloom.layout.admin')

@section('bodyClass', 'login')

@section('content')
    @if(!empty(session('message')))
        <div class="alert alert-success alert-block">
            {{ session('message') }}
        </div>
    @endif
    @if(!empty(session('error')))
        <div class="alert alert-danger alert-block">
            {{ session('error') }}
        </div>
    @endif
    <div class="sidenav">
        <div class="login-main-text">
            <h2>Application<br> Reset Password Page</h2>
            <p>Reset your password to access.</p>
        </div>
    </div>
    <div class="main">
        <div class="col-md-6 col-sm-12">
            <div class="login-form">
                @if($errors->first('email'))
                    <div class="alert alert-danger alert-block">
                        {{ $errors->first('email') }}
                    </div>
                @endif
                @if(!empty(session('status')))
                    <div class="alert alert-success alert-block">
                        {{ session('status') }}
                    </div>
                @endif
                <form method="post" action="{{ route('password.email') }}" id="form" class="w-75">
                    {{ csrf_field() }}
                    <div class="form-group">
                        <label for="email">Adresse mail</label>
                        <input id="email" type="email"
                               class="form-control @if($errors->first('email')) is-invalid @endif"
                               name="email" value="{{ old('email') }}" autocomplete="email"
                               autofocus>
                    </div>
                    <a href="javascript:document.getElementById('form').submit()"
                       class="btn btn-black btn-primary">
                        Valider
                    </a>
                </form>
            </div>
        </div>
    </div>
@endsection