<?php

/** @var Factory $factory */

use Bloom\Cms\UserModule\Data\Groupe;
use Bloom\Cms\UserModule\Data\User;
use Faker\Generator as Faker;
use Illuminate\Database\Eloquent\Factory;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

$factory->define(User::class, function (Faker $faker) {
    return [
        'name'              => $faker->name,
        'email'             => $faker->unique()->safeEmail,
        'email_verified_at' => now(),
        'password'          => Hash::make('password'), // password
        'remember_token'    => Str::random(10),
    ];
});

$factory->define(Groupe::class, function (Faker $faker) {
    return ['nom' => $faker->name];
});


