@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit')

@section('content')
    @if(!empty(session('message')))
        <div class="alert alert-success alert-block">
            {{ session('message') }}
        </div>
    @endif
    @if(!empty(session('error')))
        <div class="alert alert-danger alert-block">
            {{ session('error') }}
        </div>
    @endif
    @if($errors->first('email'))
        <div class="alert alert-danger alert-block">
            {{ $errors->first('email') }}
        </div>
    @endif
    @if($errors->first('name'))
        <div class="alert alert-danger alert-block">
            {{ $errors->first('name') }}
        </div>
    @endif
    @if(isset($user) && !($user->exists))
        @if($errors->first('password'))
            <div class="alert alert-danger alert-block">
                {{ $errors->first('password') }}
            </div>
        @endif
        @if($errors->first('password_confirmation'))
            <div class="alert alert-danger alert-block">
                {{ $errors->first('password_confirmation') }}
            </div>
        @endif
    @endif

    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>{{ isset($user) && $user->exists ? 'Éditer' : 'Ajouter' }} un utilisateur</h1>

            <span class="wrapper-btns ml-auto">
				<a href="{{ route('admin_user_index') }}" class="btn-annuler btn btn-grisclair5 btn-primary">
					Annuler
				</a>
				<a href="javascript:void(0);" class="btn-valider submit btn btn-grisclair5 btn-primary"
                   onclick="$('.main form').submit()">
					@if(isset($user) && $user->exists)
                        Modifier
                    @else
                        Valider
                    @endif
                </a>
                @if(isset($user) && $user->exists)
                    <a href="{{ route('admin_user_edit_password', $user) }}"
                       class="btn-valider btn btn-grisclair5 btn-primary">
                        Modifier le mot de passe
                    </a>
                @endif
			</span>
        </div>

        <div class="content">
            <form method="post" id="form" action="{{ route('admin_user_save', $user ?? '' ) }}">
                {{ csrf_field() }}

                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                            name="name"
                            text="Nom"
                            :value="isset($user) && $user->exists ? $user->name : old('name')"
                            form="admin"
                            :required="true"
                        />
                    </div>
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                            name="email"
                            text="Mail"
                            :value="isset($user) && $user->exists ? $user->email : old('email')"
                            form="admin"
                            :required="true"
                        />
                    </div>
                </div>

                @if(isset($user) && !($user->exists))
                    <div class="form-group row mb-0">
                        <div class="col-6 mb-4">
                            <div class="wrapper-inputs">
                                <label for="password" class="col-sm-12 control-label">Mot de passe
                                    <em>&nbsp;(8 caractères alphanumériques et un caractère spécial)</em>
                                    &nbsp;:</label>
                                <input type="password" id="password" name="password"
                                       class="form-control @if($errors->first('password')) is-invalid @endif"/>
                            </div>
                        </div>
                        <div class="col-6 mb-4">
                            <div class="wrapper-inputs">
                                <label for="password-confirm" class="col-sm-12 control-label">Confirmation de mot de
                                    passe :</label>
                                <input type="password" id="password-confirm" name="password_confirmation"
                                       class="form-control @if($errors->first('password_confirmation')) is-invalid @endif">
                            </div>
                        </div>
                    </div>
                @endif

                <div class="col-6 mb-4">
                    <label class="control-label">Groupe</label>
                    <div class="checkboxes-inline-wrapper">
                        @foreach($groupes as $groupe)
                            @php($checked = false)
                            @foreach($user_groupes as $user_groupe)
                                @if($user_groupe === $groupe->id)
                                    @php($checked = true)
                                @endif
                            @endforeach
                            <x-forms.input-custom-checkbox
                                :name="'groupes[' . $groupe->nom . ']'"
                                :text="$groupe->nom"
                                :value="$groupe->id"
                                form="admin"
                                :inline="true"
                                :checked="$checked"
                            />
                        @endforeach
                    </div>
                </div>

                @if(!empty($sites))
                    <div class="col-6 mb-4">
                        <label class="control-label">Liste des sites disponibles</label>
                        @if(count($sites) > 1)
                            <div class="custom-control custom-checkbox select-all-div">
                                <input type="checkbox" name="select-all-sites" class="custom-control-input"
                                       id="select-all-sites"
                                       checked
                                >
                                <label class="custom-control-label" for="select-all-sites"> Tout sélectionner /
                                    désélectionner</label>
                            </div>
                        @endif
                        @foreach($sites as $site)
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" name="site{{ $site->id }}"
                                       class="custom-control-input site-checkbox"
                                       id="site{{ $site->id }}"
                                       @if(isset($user) && $user->exists)
                                           @foreach($site_users as $site_user)
                                               {{ $site_user->id === $site->id?'checked':'' }}
                                           @endforeach
                                       @else
                                           checked
                                    @endif
                                >
                                <label class="custom-control-label"
                                       for="site{{ $site->id }}">{{ $site->domaine_public }}</label>
                            </div>
                        @endforeach
                    </div>
                @endif

            </form>
        </div>
    </div>
@endsection

@section('assets')
    @vite('resources/assets/js/multisites.js','vendor/cms-module-user')
@endsection
