@extends('bloom.layout.admin')

@section('bodyClass', 'login')

@section('content')
    @if(!empty(session('message')))
        <div class="alert alert-success alert-block">
            {{ session('message') }}
        </div>
    @endif
    @if(!empty(session('error')))
        <div class="alert alert-danger alert-block">
            {{ session('error') }}
        </div>
    @endif

    <div class="sidenav">
        <div class="login-main-text">
            <h2>Application<br> Reset Password Page</h2>
            <p>Reset your password to access.</p>
        </div>
    </div>

    <div class="main">
        <div class="col-md-6 col-sm-12">
            <div class="login-form">
                @if($errors->first('email'))
                    <div class="alert alert-danger alert-block">
                        {{ $errors->first('email') }}
                    </div>
                @endif
                @if($errors->first('password'))
                    <div class="alert alert-danger alert-block">
                        {{ $errors->first('password') }}
                    </div>
                @endif
                @if($errors->first('password_confirmation'))
                    <div class="alert alert-danger alert-block">
                        {{ $errors->first('password_confirmation') }}
                    </div>
                @endif

                <form method="post" action="{{ route('password_request_save') }}" id="form" class="w-75">
                    {{ csrf_field() }}

                    {{--<input type="hidden" name="token" value="{{ token|default }}">--}}
                    <input type="hidden" name="token" value="{{ $token }}">

                    <div class="form-group">
                        <label for="email">Adresse mail</label>
                        <input id="email" type="email"
                               class="form-control  @if($errors->first('email')) is-invalid @endif"
                               name="email" value="{{ $email ? $email : old('email') }}"
                               autocomplete="email" autofocus>
                    </div>

                    <div class="form-group">
                        <label for="password">Mot de passe</label>
                        <input id="password" type="password"
                               class="form-control @if($errors->first('password')) is-invalid @endif"
                               name="password" autocomplete="new-password">
                    </div>
                    <div class="form-group">
                        <label for="password-confirm">Confirmation du mot de passe</label>

                        <input id="password-confirm" type="password"
                               class="form-control @if($errors->first('password_confirmation')) is-invalid @endif"
                               name="password_confirmation" autocomplete="new-password">
                    </div>
                    <a href="javascript:document.getElementById('form').submit()"
                       class="btn btn-black btn-primary">
                        Valider le mot de passe
                    </a>
                </form>
            </div>
        </div>
    </div>
@endsection