<?php

namespace Bloom\Cms\UserModule\Notifications;


use Bloom\Cms\UserModule\Mail\NewPassword;
use Bloom\Cms\UserModule\Mail\ResetPassword;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;


class PasswordReset extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($token)
    {
        $this->token = $token;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     *
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     *
     * @return NewPassword|ResetPassword
     */
    public function toMail($notifiable)
    {

        $url = url(config('app.url') . route('password_reset', ['token' => $this->token, 'email' => $notifiable->getEmailForPasswordReset()], false));
        $count = (['count' => config('auth.passwords.' . config('auth.defaults.passwords') . '.expire')]);

        if ($notifiable->password_save == false) {

            return (new NewPassword($notifiable, $url, $count))->to($notifiable->email);
        } else {

            return (new ResetPassword($url, $count))->to($notifiable->email);
        }

    }

    /**
     * Get the array representation of the notification.
     *
     * @param mixed $notifiable
     *
     * @return array
     */
    public
    function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
