@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit')

@section('content')
    @if(!empty(session('message')))
        <div class="alert alert-success alert-block">
            {{ session('message') }}
        </div>
    @endif
    @if(!empty(session('error')))
        <div class="alert alert-danger alert-block">
            {{ session('error') }}
        </div>
    @endif
    @if($errors->first('password'))
        <div class="alert alert-danger alert-block">
            {{ $errors->first('password') }}
        </div>
    @endif
    @if($errors->first('password_confirmation'))
        <div class="alert alert-danger alert-block">
            {{ $errors->first('password_confirmation') }}
        </div>
    @endif

    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>{{ $user->exists ? 'Éditer' : 'Ajouter' }} un mot de passe utilisateur</h1>

            <span class="wrapper-btns ml-auto">
				<a href="{{ route('admin_user_index') }}" class="btn-annuler btn btn-grisclair5 btn-primary">
					Annuler
				</a>
				<a href="javascript:void(0);" class="btn-valider submit btn btn-grisclair5 btn-primary"
                   onclick="$('.main form').submit()">
					@if($user->exists)
                        Modifier
                    @else
                        Valider
                    @endif
                </a>
			</span>
        </div>

        <div class="content">
            <form method="post" id="form" action="{{ route('admin_user_save_password', $user) }}">
                {{ csrf_field() }}

                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <div class="wrapper-inputs">
                            <label for="password" class="col-sm-12 control-label">Mot de passe
                                <em>&nbsp;(8 caractères alphanumériques et un caractère spécial)</em>
                                &nbsp;:</label>
                            <input type="password" id="password" name="password"
                                   class="form-control @if($errors->first('password')) is-invalid @endif">
                        </div>
                    </div>
                    <div class="col-6 mb-4">
                        <div class="wrapper-inputs">
                            <label for="password-confirm" class="col-sm-12 control-label">Confirmation de mot de passe
                                :</label>
                            <input type="password" id="password-confirm" name="password_confirmation"
                                   class="form-control @if($errors->first('password_confirmation')) is-invalid @endif">
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection