@extends('bloom.layout.admin')

@php
    use \Carbon\Carbon;
@endphp

@section('content')
    <div class="container-fluid">
        @if(!empty(session('message')))
            <div class="alert alert-success alert-block">
                {{ session('message') }}
            </div>
        @endif
        @if(!empty(session('error')))
            <div class="alert alert-danger alert-block">
                {{ session('error') }}
            </div>
        @endif

        <div class="mb-5 heading-text d-flex justify-content-between align-items-start">
            <h1>Autorisations</h1>
        </div>
        <div class="content autorisations-list">
            @if(count($autorisations) > 1)
                <table class="table table-admin">
                    <thead>
                    <tr>
                        <th scope="col">Id</th>
                        <th scope="col">Code</th>
                        <th scope="col">Module</th>
                        <th scope="col">Nom</th>
                        <th scope="col">Créé le</th>
                        <th scope="col">Modifié le</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($autorisations as $autorisation)
                        <tr>
                            <td scope="row">{{ $autorisation->id }}</td>
                            <td>{{ $autorisation->code }}</td>
                            <td>{{ $autorisation->module->nom_public }}</td>
                            <td>{{ $autorisation->nom }}</td>
                            <td>{{ Carbon::parse($autorisation->created_at)->format('d/m/Y') }}</td>
                            <td>{{ Carbon::parse($autorisation->updated_at)->format('d/m/Y') }}</td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            @else
                <div class="alert alert-warning clearer">
                    Aucune entrée disponible...
                </div>
            @endif
        </div>
    </div>
@endsection
