@extends('bloom.layout.admin')

@section('bodyClass', 'login')

@section('login')
    <div class="sidenav">
        <div class="login-main-text">
            <img src="{{ asset('/images/admin/logo_bloom.svg') }}" alt="Bloom Multimédia" height="112" width="282"
                 class="d-block img-fluid mx-auto">
            <div class="mt-5">
                <h2>Application<br> Reset Password Page</h2>
                <p>Reset your password to access.</p>
            </div>
        </div>
    </div>

    <div class="main w-100 container-sm">
        <div class="login-main-text">
            @if(!(isset($config['icons'])))
                @php($config['icons'] = '/images/admin/logo_default.png')
            @endif
            <img src="{{ asset($config['icons']) }}" alt="{{ !(isset($config['societe'])) }}" height="100"
                 class="d-block img-fluid">
            <h1 class="nom-site mb-0">{{ isset($config['societe']) ? $config['societe'] : 'Nom du site' }}</h1>
            <p class="legend-login m-0">Connexion</p>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="login-form">
                    @if(!empty(session('message')))
                        <div class="alert alert-success alert-block">
                            {{ session('message') }}
                        </div>
                    @endif
                    @if(!empty(session('error')))
                        <div class="alert alert-danger alert-block">
                            {{ session('error') }}
                        </div>
                    @endif
                    @if($errors->first('email'))
                        <div class="alert alert-danger alert-block">
                            {{ $errors->first('email') }}
                        </div>
                    @endif
                    @if($errors->first('password'))
                        <div class="alert alert-danger alert-block">
                            {{ $errors->first('password') }}
                        </div>
                    @endif
                    @if($errors->first('password_confirmation'))
                        <div class="alert alert-danger alert-block">
                            {{ $errors->first('password_confirmation') }}
                        </div>
                    @endif

                    <form method="post" action="{{ route('password_request_save') }}" id="form" class="w-75">
                        {{ csrf_field() }}

                        {{--<input type="hidden" name="token" value="{{ token|default }}">--}}
                        <input type="hidden" name="token" value="{{ $token }}">

                        <div class="form-group">
                            <label for="email">Adresse mail</label>
                            <input id="email" type="email"
                                   class="form-control  @if($errors->first('email')) is-invalid @endif"
                                   name="email" value="{{ $email ? $email : old('email') }}"
                                   autocomplete="email" autofocus>
                        </div>

                        <div class="form-group">
                            <label for="password">Mot de passe</label>
                            <input id="password" type="password"
                                   class="form-control @if($errors->first('password')) is-invalid @endif"
                                   name="password" autocomplete="new-password">
                        </div>
                        <div class="form-group">
                            <label for="password-confirm" class="control-label">Confirmation du mot de passe</label>

                            <input id="password-confirm" type="password"
                                   class="form-control @if($errors->first('password_confirmation')) is-invalid @endif"
                                   name="password_confirmation" autocomplete="new-password">
                        </div>

                        <div class="wrapper-btns">
                            <button type="submit" class="btn btn-submit">Valider le mot de passe</button>
                            <button type="reset" class="btn btn-black btn-primary">Annuler</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
