<?php

namespace Bloom\Cms\UserModule\Mail;


use Bloom\Cms\UserModule\Data\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;


class NewPassword extends Mailable
{
    use Queueable, SerializesModels;

    public $name;
    public $link;
    public $count;
    public $url;


    /**
     * Create a new message instance.
     *
     * @param User $user
     * @param      $url
     * @param      $count
     */
    public function __construct(User $user, $url, $count)
    {
        $this->name = $user->name;
        $this->url = $url;
        $this->count = is_array($count)? $count['count'] : $count;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('UserModule::mail.mail_new_password')
            ->from(config("mail.from"), config("mail.name"))
            ->subject('Nouveau mot de passe');

    }
}
