<?php
/**
 * Created by : loic
 * Created at : 14/04/2020
 *
 * In : IntelliJ IDEA
 */


use Bloom\Cms\UserModule\Http\Controllers\Auth\ForgotPasswordController;
use Bloom\Cms\UserModule\Http\Controllers\IdentificationController;
use Bloom\Cms\UserModule\Http\Controllers\ResetPasswordController;
use Illuminate\Support\Facades\Route;


Route::post('/identification/submit', [IdentificationController::class, 'identificationSubmit'])->name('login_submit');
Route::get('/deconnexion', [IdentificationController::class, 'deconnexion'])->name('deconnexion');
Route::group(['prefix' => 'password'], function () {
    Route::post('/email', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
    Route::post('/reset', [ResetPasswordController::class, 'reset'])->name('password.update');
    Route::get('/reset_password/{token}', [ResetPasswordController::class, 'showResetForm'])->name('password_reset');
    Route::get('/reset_password',[ResetPasswordController::class, 'showLinkRequestForm'])->name('password_request');
    Route::post('/reset_password/save',[ResetPasswordController::class, 'new_mdp_save'])->name('password_request_save');
});
