@extends('bloom.layout.admin')

@section('assets')
    @vite('resources/assets/js/authentification.js', 'vendor/cms-module-user')
@endsection

@php
    use \Carbon\Carbon;
@endphp

@section('content')
    <div class="container-fluid">
        @if(!empty(session('message')))
            <div class="alert alert-success alert-block">
                {{ session('message') }}
            </div>
        @endif
        @if(!empty(session('error')))
            <div class="alert alert-danger alert-block">
                {{ session('error') }}
            </div>
        @endif

        <div class="mb-5 heading-text d-flex justify-content-between align-items-start">
            <h1>Gestion des groupes</h1>
            <a href="{{ route('admin_user_group_edit') }}" class="btn btn-grisclair5 btn-primary">Ajouter un groupe</a>
        </div>

        <div class="content">
            @if(count($groupes) > 0)
                <table class="table table-admin">
                    <thead>
                    <tr>
                        <th scope="col">Id</th>
                        <th scope="col">Nom</th>
                        <th scope="col">Créé le</th>
                        <th scope="col">Mise à jour</th>
                        <th scope="col"></th>
                    </tr>
                    </thead>
                    <tbody>
                        @foreach($groupes as $groupe)
                            <tr>
                                <td scope="row">{{ $groupe->id }}</td>
                                <td>{{ $groupe->nom }}</td>
                                <td>{{ Carbon::parse($groupe->created_at)->format('d/m/Y') }}</td>
                                <td>{{ Carbon::parse($groupe->updated_at)->format('d/m/Y') }}</td>
                                <td class="btn-group-cta btn-group-sm text-right">
                                    @if($groupe->super_admin !== true)
                                        <a href="{{ route('admin_user_group_edit', $groupe) }}"
                                           title="Edit" class="btn btn-cta btn-grisclair5">
                                            Editer
                                        </a>
                                        <a href="#"
                                           data-src="{{ route('admin_user_group_modal', $groupe) }}"
                                           title="Supprimer" class="modal_supp btn btn-cta btn-grisclair5">
                                            Supprimer
                                        </a>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <div class="alert alert-warning clearer">
                    Aucune entrée disponible.
                </div>
            @endif
        </div>
    </div>
@endsection

@section('modal')
    <div class="modal suppression_mail" id="suppression-modal" tabindex="-1" role="dialog"
         aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">

            </div>
        </div>
    </div>
@endsection
