@extends('bloom.layout.admin')

@section('bodyClass', 'login')

@section('login')
    @php($config = config('twigbridge.twig.globals'))
    <div class="sidenav">
        <div class="login-main-text">
            <img src="{{ asset('/images/admin/logo_bloom.svg') }}" alt="Bloom Multimédia" height="112" width="282"
                 class="d-block img-fluid mx-auto">
            <div class="mt-5">
                <h2>Application<br>Reset Password Page</h2>
                <p>Reset your password to access.</p>
            </div>
        </div>
    </div>

    <div class="main w-100 container-sm">
        <div class="login-main-text">
            @if(!(isset($config['icons'])))
                @php($config['icons'] = '/images/admin/logo_default.png')
            @endif
            <img src="{{ asset($config['icons']) }}" alt="{{ !(isset($config['societe'])) }}" height="100"
                 class="d-block img-fluid">
            <h1 class="nom-site mb-0">{{ isset($config['societe']) ? $config['societe'] : 'Nom du site' }}</h1>
            <p class="legend-login m-0">Connexion</p>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="login-form">
                    @if(!empty(session('message')))
                        <div class="alert alert-success alert-block">
                            {{ session('message') }}
                        </div>
                    @endif
                    @if(!empty(session('error')))
                        <div class="alert alert-danger alert-block">
                            {{ session('error') }}
                        </div>
                    @endif
                    @if($errors->first('email'))
                        <div class="alert alert-danger alert-block">
                            {{ $errors->first('email') }}
                        </div>
                    @endif
                    @if(!empty(session('status')))
                        <div class="alert alert-success alert-block">
                            {{ session('status') }}
                        </div>
                    @endif
                    <form method="post" action="{{ route('password.email') }}" id="form" class="w-75">
                        {{ csrf_field() }}

                        <div class="form-group">
                            <label class="control-label" for="email">Email</label>
                            <input id="email" name="email" type="text"
                                   class="form-control @if($errors->first('email')) is-invalid @endif"
                                   placeholder=""
                                   value="{{ old('email') }}" autocomplete="email"
                                   autofocus>
                        </div>

                        <div class="wrapper-btns">
                            <button type="submit" class="btn btn-submit">Valider</button>
                            <button type="reset" class="btn btn-black btn-primary">Annuler</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
