<?php

namespace Tests\Unit;


use Bloom\Cms\UserModule\Data\User;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Tests\Test;
use Illuminate\Foundation\Testing\RefreshDatabase;


class ResetPasswordTest extends Test
{

    use RefreshDatabase;

    /**
     * @test
     */
    public function get_show_reset_form()
    {
        $response = $this->get(route('password_reset', ['token' => Str::random(), 'email' => 'jm.gautier@bloom-multimedia.fr']));
        $response->assertSuccessful();
    }

    /**
     * @test
     */
    public function get_show_link_request_form()
    {
        $response = $this->get(route('password_request'));
        $response->assertSuccessful();
    }

    /**
     * @test
     */
    public function post_new_password_save_control_database()
    {
        $mdp = Str::random();
        $post['email'] = 'jm.gautier@bloom-multimedia.fr';
        $post['password'] = $mdp;
        $post['password_confirmation'] = $mdp;
        factory(User::class)->create(['email' => $post['email']]);
        $this->post(route('password_request_save'), $post);
        $mdpTable = DB::table('users')->where('email', $post['email'])->first();
        $this->assertDatabaseHas('users', [
            'email'         => $post['email'],
            'password'      => $mdpTable->password,
            'password_save' => 'oui'
        ]);
    }

    /**
     * @test
     */
    public function post_new_password_save_control_request()
    {
        $post['email'] = 'toto';
        $post['password'] = "";
        $post['password_confirmation'] = Str::random();
        factory(User::class)->create(['email' => $post['email']]);
        $response = $this->post(route('password_request_save'), $post);
        $response->assertSessionHasErrors(['email', 'password']);
    }
}