<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 03/03/20
 * Time: 14:56
 */

namespace Tests;


use Bloom\Cms\UserModule\CmsUserModuleProvider;
use Orchestra\Testbench\TestCase;
use TwigBridge\Facade\Twig;
use TwigBridge\ServiceProvider as TwigBridgeServiceProvider;

class Test extends TestCase
{
    protected function getPackageProviders($app)
    {
        return [CmsUserModuleProvider::class, TwigBridgeServiceProvider::class];
    }

    protected function getPackageAliases($app)
    {
        return [
            'Twig' => Twig::class,
        ];
    }

    /**
     * Setup the test environment.
     */
    protected function setUp(): void
    {
        parent::setUp();
        $this->loadLaravelMigrations('sqlite');
        $this->artisan('migrate', ['--database' => 'sqlite'])->run();
        // and other test setup steps you need to perform
    }

    protected function getEnvironmentSetUp($app)
    {
        $app['config']->set('database.connections.sqlite', [
            'driver'   => 'sqlite',
            'database' => dirname(__DIR__) . '/database/database.sqlite',
            'prefix'   => '',
        ]);
        $app['config']->set('database.default', 'testing');
        $app['config']->set('logging.default', 'single');
        $app['config']->set('logging.channels.single.path', dirname(__DIR__) . '/logs/laravel.log');
    }
}