<?php

namespace Bloom\Cms\UserModule\Http\Controllers;

use Bloom\Cms\UserModule\Data\Groupe;
use Bloom\Cms\UserModule\Data\User;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;


class UtilisateursController extends Controller
{

    use SendsPasswordResetEmails;

    private function admin($autorisation)
    {
        $admin = Auth::user()->super_admin;
        if ($admin != 1) {

            if (!Gate::allows($autorisation)) {

                return false;
            }

            return true;
        }

        return true;
    }

    public function listeUtilisateur()
    {
        if ($this->admin('USERS_LIST') == true) {

            $users = User::where('super_admin', false)->get();

            return view('UserModule::identification.liste_utilisateur', compact('users'));
        } else {
            Session::flash('error', 'Vous n\'avez pas les droits pour voir la liste des utilisateurs');

            return back();
        }

    }

    public function nouvelUtilisateur()
    {
        if ($this->admin('USERS_CREATE') == true) {
            $groupes = Groupe::all();

            return view('UserModule::identification.utilisateur', compact('groupes'));
        } else {
            Session::flash('error', 'Vous n\'avez pas les droits pour créer un nouvel utilisateur');

            return back();
        }

    }

    public function nouvelUtilisateurSave(Request $request)
    {
        if ($this->admin('USERS_CREATE') == true) {
            $validator = Validator::make($request->all(), [
                'name'  => 'required|max:60',
                'email' => 'required|email:rfc,dns',

            ]);
            if ($validator->fails()) {
                return back()
                    ->withInput(request()->all())
                    ->withErrors($validator);
            } else {
                $user = new User;
                $email = request('email');

                $verifUser = User::where('email', $email)->count();
                if ($verifUser < 1) {

                    try {
                        $user->name = request('name');
                        $user->email = request('email');
                        $user->password = Hash::make(Str::random(8));
                        DB::beginTransaction();
                        if ($user->save()) {

                            $groupes = Groupe::all();

                            foreach ($groupes as $groupe) {
                                $list_groupe = $request->input($groupe->nom);

                                if ($list_groupe == 'on') {
                                    $user->groupes()->attach([
                                        'groupes_id' => $groupe->id,
                                    ]);
                                }
                            }

                            DB::commit();
                            Session::flash('message', $user->name . ' est bien enregistré');

                        } else {
                            DB::rollBack();

                            Session::flash('error', 'Une erreur est survenu lors de l\'enregistrement');

                            return back();
                        }
                    } catch (\Exception $e) {

                        Session::flash('error', 'Une erreur est survenu lors de l\'enregistrement');
                        Log::error('error', ['Une erreur est survenu lors de l\'enregistrement']);

                        return back();
                    }
                } else {
                    Session::flash('error', 'Le mail sélectionné existe déjà en base de données');

                    return back();
                }

                $this->sendResetLinkEmail($request);

                return redirect(route('admin_user_list'));
            }
        } else {
            Session::flash('error', 'Vous n\'avez pas les droits pour créer un nouvel utilisateur');

            return back();
        }

    }

    public function deleteUser($users)
    {
        if ($this->admin('USERS_DELETE') == true) {
            $user = User::find($users);
            if ($user->super_admin == true) {
                Session::flash('error', 'Le super admin ne peut être effacer');
                Log::error('error', ['Le super admin à essayer  voulu être effacé']);

                return redirect(route('admin_user_list'));
            }
            if ($user == null) {
                Session::flash('error', 'L\'utilisateur n\'existe pas en base de données');
                Log::error('error', ['L\'utilisateur n\'existe pas en base de données']);
            } else {
                if (!$user->delete()) {

                    Session::flash('error', 'Une erreur est survenue lors de la suppression.');
                    Log::error('error', ['Une erreur est survenu lors de la suppression']);

                    return redirect(route('admin_user_list'));
                } else {
                    Session::flash('message', 'Suppression réussie.');

                    return redirect(route('admin_user_list'));
                }
            }
        } else {
            Session::flash('error', 'Vous n\'avez pas les droits pour supprimer un utilisateur');

            return back();
        }

    }

    public function editUtilisateur($user)
    {
        if ($this->admin('USERS_EDIT') == true) {
            /**
             * @var User $users
             */
            $users = User::find($user);

            if ($users == null) {

                Session::flash('error', 'L\'utilisateur n\'existe pas en base de données');
                Log::error('error', ['L\'utilisateur n\'existe pas en base de données']);

                return back();
            } else {
                $groupes = Groupe::all();

                $user_groupes = $users->groupes()->pluck("groupes_id");

                return view('UserModule::identification.utilisateur', compact('users', 'groupes', 'user_groupes'));
            }
        } else {

            Session::flash('error', 'Vous n\'avez pas les droits pour éditer un utilisateur');

            return back();
        }
    }

    public function editUtilisateurSave($user, Request $request)
    {
        if ($this->admin('USERS_EDIT') == true) {
            /**
             * @var User $users
             */
            $users = User::find($user);
            if ($users->super_admin == true) {
                Session::flash('error', 'Le super admin ne peut être modifié');
                Log::error('error', ['Le super admin à voulu être modifié']);

                return redirect(route('admin_user_list'));
            }
            if ($users == null) {
                Session::flash('error', 'L\'utilisateur n\'existe pas en base de données');
                Log::error('error', ['L\'utilisateur n\'existe pas en base de données']);
            } else {
                $validator = Validator::make($request->all(), [
                    'name'  => 'required|max:60',
                    'email' => 'required|email:rfc,dns',

                ]);
                if ($validator->fails()) {
                    return back()
                        ->withInput(request()->all())
                        ->withErrors($validator);
                } else {
                    DB::beginTransaction();
                    $users->groupes()->detach();
                    $groupes = Groupe::all();
                    foreach ($groupes as $groupe) {
                        $list_groupe = $request->input($groupe->nom);
                        if ($list_groupe == 'on') {
                            $users->groupes()->attach([
                                'groupes_id' => $groupe->id,
                            ]);
                        }
                    }
                    $users->email = request('email');
                    $users->name = request('name');
                    if ($users->save()) {

                        DB::commit();
                        session()->flash('message', 'Enregistrement ok');

                        return redirect(route('admin_user_list'));
                    } else {

                        DB::rollBack();
                        session()->flash('error', "Problème d'enregistrement");
                        Log::error('error', ['Une erreur est survenu lors de la modification de l\'utilisateur']);

                        return redirect(route('admin_user_list'));
                    }
                }
            }
        } else {
            Session::flash('error', 'Vous n\'avez pas les droits pour éditer un utilisateur');

            return back();
        }
    }
}

