<?php

namespace Bloom\Cms\UserModule\Http\Controllers;

use Bloom\Cms\UserModule\{Data\Autorisation, Data\Groupe, Data\GroupeAutorisation};
use Illuminate\Http\Request;
use Illuminate\Support\Facades\{Auth, DB, Gate, Log, Session, Validator};

class GroupeController extends Controller
{
    private function admin($autorisation)
    {
        $admin = Auth::user()->super_admin;
        if ($admin != 1) {
            if (!Gate::allows($autorisation)) {
                return false;
            }

            return true;
        }

        return true;
    }

    public function listeGroupe()
    {
        if ($this->admin('USERS_G_LIST') == true) {
            $groupes = Groupe::all();

            return view('UserModule::groupe.liste_groupe', compact('groupes'));
        } else {
            Session::flash('error', 'Vous n\'avez pas les droits pour voir la liste des groupes');

            return back();
        }
    }

    public function nouveauGroupeSave(Request $request)
    {

        if ($this->admin('USERS_G_CREATE') == true) {
            $validator = Validator::make($request->all(), [
                'nom' => 'required|max:60',
            ]);
            if ($validator->fails()) {
                return back()
                    ->withInput(request()->all())
                    ->withErrors($validator);
            } else {
                $groupe = new Groupe();
                $nom = request('nom');
                $verifGroupe = Groupe::where('nom', $nom)->count();
                if ($verifGroupe < 1) {
                    $groupe->nom = request('nom');
                    DB::beginTransaction();
                    try {
                        if ($groupe->save()) {
                            $autorisations = Autorisation::all();
                            $groupe_autorisation = new GroupeAutorisation();
                            foreach ($autorisations as $autorisation) {
                                $autorisationNom = request($autorisation->nom);
                                if ($autorisationNom == 'on') {
                                    $groupe_autorisation->create([
                                        'groupes_id'       => $groupe->id,
                                        'autorisations_id' => $autorisation->id,
                                    ]);
                                }
                            }
                            DB::commit();
                            Session::flash('message', $groupe->nom . ' est bien enregistré');

                        } else {
                            Session::flash('error', 'Une erreur est survenu lors de l\'enregistrement');
                        }
                    } catch (\Exception $e) {
                        DB::rollBack();
                        Session::flash('error', 'Une erreur est survenu lors de l\'enregistrement');
                    }
                } else {
                    Session::flash('error', 'Le groupe sélectionné existe déjà en base de données');
                }

                return redirect(route('admin_group_list'));
            }
        } else {
            Session::flash('error', 'Vous n\'avez pas les droits pour créer un nouveau groupe');

            return back();
        }

    }

    public function nouveauGroupe()
    {
        if ($this->admin('USERS_G_CREATE') == true) {
            $autorisations = Autorisation::all();

            return view('UserModule::groupe.groupe', compact('autorisations'));
        } else {
            Session::flash('error', 'Vous n\'avez pas les droits pour créer un nouveau groupe');

            return back();
        }
    }

    public function editGroupe(Groupe $groupe)
    {
        if ($this->admin('USERS_G_EDIT') == true) {
            $autorisations = Autorisation::all();
            $groupe_autorisations = $groupe->auths()->pluck('autorisations_id');

            return view('UserModule::groupe.groupe', compact('groupe', 'autorisations', 'groupe_autorisations'));

        } else {
            Session::flash('error', 'Vous n\'avez pas les droits pour éditer les groupes');

            return back();
        }
    }

    public function editGroupeSave(Groupe $groupe, Request $request)
    {
        if ($groupe->super_admin == true) {
            Session::flash('error', 'Les autorisations du groupe admin ne peuvent être modifié');
            Log::error('error', ['Les autorisations de l\'admin ont essayé d\être modifié']);

            return redirect(route('admin_group_list'));
        }

        if ($this->admin('USERS_G_EDIT') == true) {
            $validator = Validator::make($request->all(), [
                'nom' => 'required|max:60',
            ]);
            if ($validator->fails()) {
                return back()
                    ->withInput(request()->all())
                    ->withErrors($validator);
            } else {
                DB::beginTransaction();
                $autorisations = Autorisation::all();
                $groupe->auths()->detach();

                foreach ($autorisations as $autorisation) {

                    $autorisationNom = request($autorisation->nom);

                    if ($autorisationNom == 'on') {
                        $groupe->auths()->attach([
                            'autorisations_id' => $autorisation->id,
                        ]);
                    }
                }
                $groupe->nom = request('nom');
                if ($groupe->save()) {
                    DB::commit();
                    session()->flash('message', 'Enregistrement ok');
                } else {
                    session()->flash('error', "Problème d'enregistrement");
                    DB::rollBack();
                }

                return redirect(route('admin_group_list'));
            }
        } else {
            Session::flash('error', 'Vous n\'avez pas les droits pour éditer les groupes');

            return back();
        }

    }

    public function deleteGroupe($groupe)
    {
        /**
         * @var Groupe $groupes
         */

        $groupes = Groupe::find($groupe);
        if ($groupes->super_admin == true) {
            Session::flash('error', 'Le groupe admin ne peut être effacer');
            Log::error('error', ['Le groupe admin à voulu être effacé']);

            return redirect(route('admin_group_list'));
        }

        if ($this->admin('USERS_G_DELETE') == true) {
            if (!$groupes->delete()) {
                Session::flash('error', 'Une erreur est survenue lors de la suppression.');
            } else {
                Session::flash('message', 'Suppression réussie.');
            }

            return redirect(route('admin_group_list'));
        } else {
            Session::flash('error', 'Vous n\'avez pas les droits pour supprimer un groupe');

            return back();
        }

    }

}

