<?php

namespace Bloom\Cms\UserModule\Commands;

use Bloom\Cms\UserModule\Data\Autorisation;
use Bloom\Cms\UserModule\Data\GroupeAutorisation;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;


class InitProject extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'authentification';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Importe les fichiers de migrations, de traduction, de seeds et fait une migration';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        if (Schema::hasTable('autorisations') && Autorisation::count() > 0) return;
        if (Schema::hasTable('autorisations') && Schema::hasTable('groupe_autorisations')) {

            DB::statement('SET FOREIGN_KEY_CHECKS=0;');
            GroupeAutorisation::query()->truncate();
            Autorisation::query()->truncate();
            DB::statement('SET FOREIGN_KEY_CHECKS=1;');
        }

        $this->call('vendor:publish', ['--tag' => 'public']);
        $this->call('vendor:publish', ['--tag' => 'lang']);
        $this->call('vendor:publish', ['--tag' => 'seeds']);
        $this->call('vendor:publish', ['--tag' => 'tests']);
        $this->call('migrate');
        $this->call('db:seed', ['--class' => 'AutorisationTableSeeder']);

    }
}
