<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUserGroupesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_groupes', function (Blueprint $table) {
            $table->increments('id');
            $table->bigInteger('user_id', false, true);
            $table->integer('groupes_id', false, true);
            $table->timestamps();
            $table->foreign(['groupes_id'])->references('id')->on('groupes')->onDelete('cascade');
            $table->foreign(['user_id'])->references('id')->on('users')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_groupes');
    }
}
