@extends('bloom.layout.admin')

@section('assets')
    @vite('resources/assets/js/authentification.js','/vendor/cms-module-user')
@endsection

@section('content')
    <div class="container-fluid">
        @if(!empty(session('message')))
            <div class="alert alert-success alert-block">
                {{ session('message') }}
            </div>
        @endif
        @if(!empty(session('error')))
            <div class="alert alert-danger alert-block">
                {{ session('error') }}
            </div>
        @endif
        <div class="mb-5 heading-text d-flex justify-content-between align-items-start">
            <h1>Gestion des utilisateurs</h1>
            <a href="{{ route('admin_user_edit') }}" class="btn btn-grisclair5 btn-primary">Ajouter un utilisateur</a>
        </div>
        <div class="content">
            @if(count($users) > 0)
                @php($way = "asc")
                <table class="table table-admin">
                    <thead>
                    <tr>
                        <th scope="col">
                            <a class="order-me">
                                <span class="text">Id</span>
                                <span class="sort">
                                    <span class="bloomicon-admin-chevron-up" aria-hidden="true"></span>
                                    <span class="bloomicon-admin-chevron-down" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col">
                            <a class="order-me">
                                <span class="text">Nom</span>
                                <span class="sort">
                                    <span class="bloomicon-admin-chevron-up" aria-hidden="true"></span>
                                    <span class="bloomicon-admin-chevron-down" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col">
                            Email
                        </th>
                        <th scope="col">
                            <a class="order-me">
                                <span class="text">Créé le</span>
                                <span class="sort">
                                    <span class="bloomicon-admin-chevron-up" aria-hidden="true"></span>
                                    <span class="bloomicon-admin-chevron-down" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col">
                            <a class="order-me">
                                <span class="text">Modifié le</span>
                                <span class="sort">
                                    <span class="bloomicon-admin-chevron-up" aria-hidden="true"></span>
                                    <span class="bloomicon-admin-chevron-down" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col"></th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($users as $user)
                        <tr>
                            <td scope="row">{{ $user->id }}</td>
                            <td>{{ $user->name }}</td>
                            <td>{{ $user->email }}</td>
                            <td>{{ Carbon::parse($user->created_at)->format('d/m/Y') }}</td>
                            <td>{{ Carbon::parse($user->updated_at)->format('d/m/Y') }}</td>
                            <td class="btn-group-cta btn-group-sm text-right">
                                <a href="{{ route('admin_user_edit', $user) }}" title="Edit"
                                   class="btn btn-cta btn-grisclair5">
                                    Editer
                                </a>
                                <a href="#" data-src="{{ route('admin_user_modal', $user) }}" title="Supprimer"
                                   class="modal_supp btn btn-cta btn-grisclair5">
                                    Supprimer
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            @else
                <div class="alert alert-warning clearer">
                    Aucune entrée disponible.
                </div>
            @endif
        </div>
    </div>
@endsection

@section('modal')
    <div class="modal  suppression_mail" id="suppression-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">

            </div>
        </div>
    </div>
@endsection


