@extends('bloom.layout.admin')

@section('assets')
    <script src="{{ mix('/authentification.js','/vendor/cms-module-user') }}"></script>
@endsection

@section('content')
    <div class="container-fluid">
        @if(!empty(session('message')))
            <div class="alert alert-success alert-block">
                {{ session('message') }}
            </div>
        @endif
        @if(!empty(session('error')))
            <div class="alert alert-danger alert-block">
                {{ session('error') }}
            </div>
        @endif

        <div class="mb-5 heading-text d-flex justify-content-between align-items-start">
            <h1>Gestion des groupes</h1>
            <a href="{{ route('admin_user_group_edit') }}" class="btn btn-grisclair5 btn-primary">Ajouter un groupe</a>
        </div>

        <div class="content">
            @if(count($groupes) > 0)
                <table class="table table-admin">
                    <thead>
                    <tr>
                        <th scope="col">Id</th>
                        <th scope="col">Nom</th>
                        {{--<th scope="col">Code</th>--}}
                        <th scope="col">Créé le</th>
                        <th scope="col">Mise à jour</th>
                        <th scope="col"></th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($groupes as $groupe)
                        <tr>
                            <td scope="row">{{ $groupe->id }}</td>
                            <td>{{ $groupe->nom }}</td>
                            {#
                            <td>{{ $groupe->code }}</td>
                            #}
                            <td>{{ $groupe->created_at|date('d/m/Y') }}</td>
                            <td>{{ $groupe->updated_at|date('d/m/Y') }}</td>
                            <td class="btn-group-cta btn-group-sm text-right">
                                @if($groupe->super_admin !== true)
                                    <a href="{{ route('admin_user_group_edit', $groupe) }}"
                                       title="Edit" class="btn btn-cta btn-grisclair5">
                                        Editer
                                    </a>
                                @endif
                                <a href="#" @if($groupe->super_admin !== true)
                                    data-src="{{ route('admin_user_group_modal', $groupe) }}"
                                   title="Supprimer" class="modal_supp btn btn-cta btn-grisclair5">
                                    Supprimer
                                    @endif
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            @else
                <div class="alert alert-warning clearer">
                    Aucune entrée disponible.
                </div>
            @endif
        </div>
    </div>
@endsection

@section('modal')
    <div class="modal suppression_mail" id="suppression-modal" tabindex="-1" role="dialog"
         aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">

            </div>
        </div>
    </div>
@endsection


