<?php

namespace Bloom\Cms\UserModule\Http\Controllers;

use Bloom\Cms\UserModule\CmsUserModuleProvider;
use Bloom\Cms\UserModule\Data\Groupe;
use Bloom\Cms\UserModule\Data\User;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

/**
 * Class UtilisateursController
 * @package Bloom\Cms\UserModule\Http\Controllers
 */
class UtilisateursController extends Controller
{
    use SendsPasswordResetEmails;

    private function admin($autorisation): bool
    {
        if (Auth::user()->super_admin) {
            return true;
        }

        return Gate::allows($autorisation);
    }

    public function index()
    {
        if ($this->admin(CmsUserModuleProvider::USERS_LIST) === true) {
            $users = User::where('super_admin', false)->get();

            return view('User::identification.liste_utilisateur', compact('users'));
        } else {
            Session::flash('error', 'Vous n\'avez pas les droits pour voir la liste des utilisateurs');

            return back();
        }
    }

    public function delete(User $user)
    {
        if ($this->admin(CmsUserModuleProvider::USERS_DELETE)) {
            if ($user->super_admin == true) {
                Session::flash('error', 'Le super admin ne peut être effacer');
                Log::error('error', ['Le super admin à essayer  voulu être effacé']);

                return redirect(route('admin_user_index'));
            }
            if (!$user->exists) {
                Session::flash('error', 'L\'utilisateur n\'existe pas en base de données');
                Log::error('error', ['L\'utilisateur n\'existe pas en base de données']);

                return redirect(route('admin_user_index'));
            } elseif (!$user->delete()) {
                Session::flash('error', 'Une erreur est survenue lors de la suppression.');
                Log::error('error', ['Une erreur est survenu lors de la suppression']);

                return redirect(route('admin_user_index'));
            } else {
                Session::flash('message', 'Suppression réussie.');

                return redirect(route('admin_user_index'));
            }
        } else {
            Session::flash('error', 'Vous n\'avez pas les droits pour supprimer un utilisateur');

            return back();
        }
    }

    public function edit(User $user)
    {
        if (!$user->exists) {
            // création
            if (!$this->admin(CmsUserModuleProvider::USERS_CREATE)) {
                Session::flash('error', 'Vous n\'avez pas les droits pour créer un nouvel utilisateur');

                return back();
            }
            $groupes = Groupe::all();

            return view('User::identification.utilisateur', compact('groupes'));
        }
        if (!$this->admin(CmsUserModuleProvider::USERS_EDIT)) {
            Session::flash('error', 'Vous n\'avez pas les droits pour éditer un utilisateur');

            return back();
        }

        $groupes = Groupe::all();
        $user_groupes = $user->groupes()->pluck("groupes_id");

        return view('User::identification.utilisateur', compact('user', 'groupes', 'user_groupes'));
    }

    public function save(User $user, Request $request)
    {
        if ($user->exists) {
            if (!$this->admin(CmsUserModuleProvider::USERS_EDIT)) {
                Session::flash('error', 'Vous n\'avez pas les droits pour éditer un utilisateur');

                return back();
            }
            if ($user->super_admin) {
                Session::flash('error', 'Le super admin ne peut être modifié');
                Log::error('error', ['Le super admin à voulu être modifié']);

                return redirect(route('admin_user_index'));
            }
            $validator = Validator::make($request->all(), [
                'name'  => 'required|max:60',
                'email' => 'required|email:rfc,dns',

            ]);
            if ($validator->fails()) {
                return back()
                    ->withInput(request()->all())
                    ->withErrors($validator);
            } else {
                DB::beginTransaction();
                $user->groupes()->detach();
                $groupes = Groupe::all();
                foreach ($groupes as $groupe) {
                    $list_groupe = $request->input($groupe->nom);
                    if ($list_groupe == 'on') {
                        $user->groupes()->attach([
                            'groupes_id' => $groupe->id,
                        ]);
                    }
                }
                $user->email = request('email');
                $user->name = request('name');
                if ($user->save()) {
                    DB::commit();
                    session()->flash('message', 'Enregistrement ok');

                    return redirect(route('admin_user_index'));
                } else {
                    DB::rollBack();
                    session()->flash('error', "Problème d'enregistrement");
                    Log::error('error', ['Une erreur est survenu lors de la modification de l\'utilisateur']);

                    return redirect(route('admin_user_index'));
                }
            }
        } else {
            if (!$this->admin('USERS_CREATE')) {
                Session::flash('error', 'Vous n\'avez pas les droits pour créer un nouvel utilisateur');

                return back();
            }
            $validator = Validator::make($request->all(), [
                'name'  => 'required|max:60',
                'email' => 'required|email:rfc,dns',

            ]);
            if ($validator->fails()) {
                return back()
                    ->withInput(request()->all())
                    ->withErrors($validator);
            } else {
                $email = request('email');

                $verifUser = User::where('email', $email)->count();
                if ($verifUser < 1) {
                    try {
                        $user->name = request('name');
                        $user->email = request('email');
                        $user->password = Hash::make(Str::random(8));
                        DB::beginTransaction();
                        if ($user->save()) {
                            $groupes = Groupe::all();

                            foreach ($groupes as $groupe) {
                                $list_groupe = $request->input($groupe->nom);

                                if ($list_groupe == 'on') {
                                    $user->groupes()->attach([
                                        'groupes_id' => $groupe->id,
                                    ]);
                                }
                            }

                            DB::commit();
                            Session::flash('message', $user->name . ' est bien enregistré');
                        } else {
                            DB::rollBack();
                            Session::flash('error', 'Une erreur est survenu lors de l\'enregistrement');

                            return back();
                        }
                    } catch (\Exception $e) {
                        Session::flash('error', 'Une erreur est survenu lors de l\'enregistrement');
                        Log::error('error', ['Une erreur est survenu lors de l\'enregistrement']);

                        return back();
                    }
                } else {
                    Session::flash('error', 'Le mail sélectionné existe déjà en base de données');

                    return back();
                }

                $this->sendResetLinkEmail($request);

                return redirect(route('admin_user_index'));
            }
        }
    }
}
