<?php


namespace Bloom\Cms\UserModule\Data;

use Bloom\Cms\UserModule\Notifications\PasswordReset;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Notifications\Notifiable;

/**
 * Class User
 * @package Bloom\Cms\Authentification\Data
 *
 * @property UserGroupe[]|Collection groupes
 * @property bool                    super_admin
 * @property string                  email
 * @property string                  password
 * @property string                  name
 */
class User extends \Illuminate\Foundation\Auth\User
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function groupes()
    {

        return $this->belongsToMany(Groupe::class, 'user_groupes', 'user_id', 'groupes_id')->withPivot(['created_at', 'updated_at']);

    }

    public function sendPasswordResetNotification($token)
    {
        $this->notify(new PasswordReset($token));
    }
}
