<?php

namespace Bloom\Cms\UserModule\Commands;


use Bloom\Cms\UserModule\Data\Autorisation;
use Bloom\Cms\UserModule\Data\Groupe;
use Bloom\Cms\UserModule\Data\GroupeAutorisation;
use Bloom\Cms\UserModule\Data\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;


class Admin extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'admin';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Créer le compte administrateur';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $user = new User();

        $s_admin = User::where('super_admin', true)->count();
        if ($s_admin < 1) {
            $name = $this->ask('Nom de l\'administrateur');
            $email = $this->ask('Mail de l\'administrateur:');
            $mdp = $this->secret('Mot de passe de l\'administrateur');
            DB::beginTransaction();
            $user = new User;
            $user->name = $name;
            $user->email = $email;
            $user->password = Hash::make($mdp);
            $user->super_admin = true;

            try {
                if ($user->save()) {

                    $groupe = Groupe::firstOrCreate(['nom' => 'Admin'], ['super_admin' => true], ['password_save' => true]);
                    $groupeId = $groupe->id;
                    $autorisations = Autorisation::all();
                    foreach ($autorisations as $autorisation) {
                        $groupeAutorisation = new GroupeAutorisation();
                        $groupeAutorisation->groupes_id = $groupeId;
                        $groupeAutorisation->autorisations_id = $autorisation->id;
                        $groupeAutorisation->save();

                    }
                    $user->groupes()->attach([
                        'groupes_id' => $groupe->id,
                    ]);
                }

                DB::commit();
            } catch (\Exception $e) {
                DB::rollBack();
                $this->error('Erreur d\'enregistrement');
            }
        } else {
            $this->info('Un super administrateur est déjà enregistré');
        }
    }

}
