<?php

namespace Bloom\Cms\UserModule;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Framework\Admin\AdminMenu;
use Bloom\Cms\UserModule\{Commands\Admin, Data\Autorisation, Data\User};
use Illuminate\Foundation\AliasLoader;
use Illuminate\Support\{Facades\DB, Facades\Gate, Facades\Log, Facades\Schema};


class CmsUserModuleProvider extends BloomProvider
{
    protected $nom = "Utilisateurs";
    protected $code = "user";
    protected $icons = "user";
    protected $registeredCommands = [
        Admin::class
    ];
    public const USERS_LIST = 'USERS_LIST';

    public const USERS_EDIT = 'USERS_EDIT';
    public const USERS_DELETE = 'USERS_DELETE';
    public const USERS_CREATE = 'USERS_CREATE';
    public const USERS_G_EDIT = 'USERS_G_EDIT';
    public const USERS_G_DELETE = 'USERS_G_DELETE';
    public const USERS_G_LIST = 'USERS_G_LIST';
    public const USERS_G_CREATE = 'USERS_G_CREATE';

    /**
     * Bootstrap services.
     * @return void
     */
    public function boot()
    {
        parent::boot();
        $loader = AliasLoader::getInstance();
        $loader->alias('App\User', 'Bloom\Cms\UserModule\Data\User');
        $loader->alias(
            'App\Http\Controllers\Auth\ForgotPasswordController',
            'Bloom\Cms\UserModule\Http\Controllers\Auth\ForgotPasswordController'
        );
        $loader->alias(
            'App\Http\Controllers\Auth\ResetPasswordController',
            'Bloom\Cms\UserModule\Http\Controllers\Auth\ResetPasswordController'
        );
        if (Schema::hasTable('autorisations')) {
            foreach (Autorisation::all() as $auth) {
                Log::debug("Gate", ['auth' => $auth]);
                if (!Gate::allows($auth->code)) {
                    Gate::define($auth->code, function (User $user) use ($auth) {
                        foreach ($user->groupes as $groupe_id) {
                            if (DB::table('groupe_autorisations')
                                    ->where('groupes_id', $groupe_id->pivot->groupes_id)
                                    ->where('autorisations_id', $auth->id)
                                    ->count() > 0) {
                                return true;
                            }
                        }

                        return false;
                    });
                }
            }
        }
        $this->addSubMenus([
            new AdminMenu([
                'label' => 'Utilisateurs',
                'route' => 'admin_user_index',
            ]),
            new AdminMenu([
                'label' => 'Groupes',
                'route' => 'admin_user_group_index',
            ]),
            new AdminMenu([
                'label' => 'Autorisations',
                'route' => 'admin_user_auth_index',
            ]),
        ]);
        $this->loadViewsFrom(dirname(__DIR__) . '/resources/views', 'UserModule');
    }
}
