<?php

namespace Bloom\Cms\UserModule\Http\Controllers;

use Bloom\Cms\UserModule\CmsUserModuleProvider;
use Bloom\Cms\UserModule\Data\Autorisation;
use Bloom\Cms\UserModule\Data\User;

/**
 * Class AutorisationController
 * @package Bloom\Cms\UserModule\Http\Controllers
 */
class AutorisationController extends Controller
{
    public function index()
    {
        if (!CmsUserModuleProvider::admin(CmsUserModuleProvider::USERS_A_LIST, 'Vous n\'avez pas les droits pour voir la liste des autorisations')) {
            return back();
        }

        $autorisations = Autorisation::all();

        return view('User::autorisation.liste_autorisation', compact('autorisations'));
    }
}
