<?php
namespace Database\Seeders;

use Bloom\Cms\UserModule\Data\Autorisation;
use Bloom\Cms\UserModule\Data\Groupe;
use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class GroupeTableSeeder extends Seeder
{
  /**
   * Run the database seeders.
   *
   * @return void
   */
  public function run()
  {
    if (Schema::hasTable('modules')) {
      $modules = DB::table("modules")->where("nom", "user")->first();
      if ($modules != null) {
        $groupe = new Groupe();
        $groupe->nom = 'Concessionnaire';
        $groupe->code = 'CONCESS';
        $auth_list = [
          'USERS_LIST',
          'USERS_CREATE',
          'USERS_EDIT',
        ];
        $autorisations = Autorisation::whereIn('code', $auth_list)->get();
        $groupe->save();
        $groupe->auths()->attach($autorisations);
        $groupe->save();
      }
    }
  }
}
