<?php

namespace Bloom\Cms\UserModule\Data;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Autorisation
 * @package Bloom\Cms\Authentification\Data
 *
 *   En base
 * @property int    $id
 * @property string $code
 * @property string $module
 * @property string $nom
 * @property string $description
 * @property Carbon $created_at
 * @property Carbon $updated_at
 */
class Autorisation extends Model
{
    protected $fillable = [];

    public function groupeAutorisation()
    {
        return $this->belongsToMany(
            Groupe::class,
            'groupe_autorisations',
            'autorisations_id',
            'groupes_id'
        )->withPivot(['created_at', 'updated_at']);
    }
}
