<?php

namespace Bloom\CMS\HPV\Specialites\Http\Controllers;

use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Specialites\Model\SpecialitesCategorie;
use Illuminate\Routing\Controller;

/**
 * Class FrontController
 * @package Bloom\CMS\HPV\Specialites\Http\Controllers
 */
class FrontController extends Controller
{
    public function index(Page $page)
    {
        $breadcrumbElements = [];
        $dossier = $page->dossier;
        while ($dossier !== null) {
            $breadcrumbElements[] = ['name' => $dossier->name, 'url' => $dossier->full_pathname];
            $dossier = $dossier->parent;
        }

        $breadcrumbElements = array_reverse($breadcrumbElements);

        $categories = SpecialitesCategorie::all();

        return view('Specialite::front.index', compact('page', 'categories', 'breadcrumbElements'));
    }
}
