<?php

namespace Bloom\CMS\HPV\Specialites\Model;

use Bloom\CMS\Core\Contenus\Contenu;
use Bloom\CMS\Core\Contenus\ContenuHandler;
use Bloom\CMS\Core\Contenus\IsContenu;
use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Specialites\SpecialitesServiceProvider;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\{Builder, Collection, Model};
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Response;
use Bloom\CMS\HPV\Praticiens\Model\Praticien;

/**
 * Class Specialite
 *
 * @package Bloom\CMS\HPV\Specialites\Model
 *
 * @property int                  $id
 * @property string               $nom
 * @property string               $contenu
 * @property Carbon               $created_at
 * @property Carbon               $updated_at
 *
 * @property Page                 $page
 * @property SpecialitesCategorie $categorie
 */
class Specialite extends Model implements Contenu
{
    use IsContenu;

    public function getHandler(): ContenuHandler
    {
        return new class implements ContenuHandler {

            public function single(Contenu $contenu): Response
            {
                $page = $contenu->page;
                $breadcrumbElements = [
                    ["name" => $page->titre, 'url' => ''],
                ];
                if ($page->dossier) {
                    $dossier = $page->dossier;
                    while ($dossier !== null) {
                        $breadcrumbElements[] = ['name' => $dossier->name, 'url' => $dossier->full_pathname];
                        $dossier = $dossier->parent;
                    }
                }

                $breadcrumbElements = array_reverse($breadcrumbElements);
                $index = Page::query()
                    ->where(
                        'dossier_id',
                        '=',
                        Dossier::query()
                            ->where('name', '=', SpecialitesServiceProvider::DOSSIER_NAME)
                            ->first(['id'])
                            ->id
                    )->where('is_index', '=', 1)->first();

                $praticiens = Praticien::published()->get()
                    ->filter(function ($praticiens) use ($contenu) {
                    return $praticiens->specialites
                            ->filter(function ($specialite) use ($contenu) {
                                return $specialite->id === $contenu->id;
                            })->count() > 0;
                });

                return response(
                    view(
                        'Specialite::front.detail',
                        compact('page', 'breadcrumbElements', 'contenu', 'praticiens', 'index')
                    )
                );
            }

            public function multiple(Collection $contenus): Response
            {
            }

            public function ensemble()
            {
            }
        };
    }

    public function categorie()
    {
        return $this->belongsTo(SpecialitesCategorie::class, 'specialites_categorie_id');
    }

    public function scopePublished(Builder $query)
    {
        return $this->scopeStatus($query, 1);
    }

    public function scopeArchived(Builder $query)
    {
        return $this->scopeStatus($query, 0);
    }

    public function scopeStatus(Builder $query, int $status)
    {
        return $query->whereHas('page', function (Builder $query) use ($status) {
            return $query->where('statut_id', '=', $status);
        });
    }

    public function scopeProgrammed(Builder $query)
    {
        return $query->whereHas('page', function (Builder $query) {
            return $query->whereNotNull('to_publish_at')
                ->where('statut_id', '=', 2);
        });
    }

    public function scopeNotProgrammed(Builder $query)
    {
        return $query->whereHas('page', function (Builder $query) {
            return $query->whereNull('to_publish_at');
        });
    }
}
