<?php

namespace Bloom\CMS\HPV\Specialites;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Contenus\PageStatique;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Framework\Admin\AdminMenu;
use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Specialites\Http\Controllers\AdminController;
use Bloom\CMS\HPV\Specialites\Http\Controllers\FrontController;
use Bloom\CMS\HPV\Specialites\Model\Specialite;
use Bloom\CMS\HPV\Specialites\Model\SpecialitesCategorie;
use Illuminate\Support\Facades\Schema;

class SpecialitesServiceProvider extends BloomProvider
{
    public const DOSSIER_NAME = 'Spécialités';
    protected $nom = "Specialites";
    protected $code = "specialite";
    protected $icons = "?";

    public function boot()
    {
        parent::boot();
        Page::declareContenu(Specialite::class);
        if (Schema::hasTable('page_statiques') && !PageStatique::query()->where('controller', '=', FrontController::class . '@index')->exists()) {
            // Ajout de la page de listing des spécialité pour le front (dossier parent de toutes les spécialités)
            $statique = new PageStatique(
                [
                    'display_type' => 'Spécialités',
                    'action'       => 'Gérer les spécialités',
                    'route'        => 'admin_specialite_index',
                    'controller'   => FrontController::class . '@index'
                ]
            );
            $statique->save();
            // Création du dossier avec un nom filtrable pour le rattachement des pages enfants
            $dossier = new Dossier();
            $dossier->type = "simple";
            $dossier->name = self::DOSSIER_NAME;
            $dossier->slug = 'specialites';
            $dossier->save();
            // Création de la page index
            $page = new Page();
            $page->contenu()->associate($statique);
            $page->dossier()->associate($dossier);
            $page->titre = "Spécialités";
            $page->slug = "";
            $page->meta_description = "";
            $page->meta_titre = "";
            $page->intro = "<p>Texte d'introduction de la page Spécialités. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at porttitor sem.</p>";
            $page->multiplicity = 1;
            $page->statut_id = Statut::PUBLIE;
            $page->is_index = 1;
            $page->save();
        }
        if (Schema::hasTable('specialites_categories')) {
            $sub_menus = [];
            foreach (SpecialitesCategorie::all() as $cat) {
                /**
                 * @var SpecialitesCategorie $cat
                 */
                $sub_menus[] = new AdminMenu(['label' => $cat->nom, 'route' => 'admin_specialite_index']);
            }
            $this->addSubMenus($sub_menus);
        }
    }
}
