<?php

namespace Bloom\CMS\HPV\Specialites;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Contenus\PageStatique;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Framework\Admin\AdminMenu;
use Bloom\CMS\Core\Helpers\Actions;
use Bloom\CMS\Core\Helpers\TableHeader;
use Bloom\CMS\Core\Helpers\WorkflowsFactory;
use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Specialites\Http\Controllers\AdminController;
use Bloom\CMS\HPV\Specialites\Http\Controllers\FrontController;
use Bloom\CMS\HPV\Specialites\Model\Specialite;
use Bloom\CMS\HPV\Specialites\Model\SpecialitesCategorie;
use Illuminate\Support\Facades\Schema;

class SpecialitesServiceProvider extends BloomProvider
{
    public const DOSSIER_NAME = 'Spécialités';
    protected $nom = "Specialites";
    protected $code = "specialite";
    protected $icons = "?";

    public function boot()
    {
        parent::boot();
        Page::declareContenu(Specialite::class);
        if (Schema::hasTable('page_statiques') && !PageStatique::query()->where('controller', '=', FrontController::class . '@index')->exists()) {
            // Ajout de la page de listing des spécialité pour le front (dossier parent de toutes les spécialités)
            $statique = new PageStatique(
                [
                    'display_type' => 'Spécialités',
                    'action'       => 'Gérer les spécialités',
                    'route'        => 'admin_specialite_index',
                    'controller'   => FrontController::class . '@index'
                ]
            );
            $statique->save();
            // Création du dossier avec un nom filtrable pour le rattachement des pages enfants
            $dossier = new Dossier();
            $dossier->type = "simple";
            $dossier->name = self::DOSSIER_NAME;
            $dossier->slug = 'specialites';
            $dossier->save();
            // Création de la page index
            $page = new Page();
            $page->contenu()->associate($statique);
            $page->dossier()->associate($dossier);
            $page->titre = "Spécialités";
            $page->slug = "";
            $page->meta_description = "";
            $page->meta_titre = "";
            $page->intro = "<p>Texte d'introduction de la page Spécialités. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam at porttitor sem.</p>";
            $page->multiplicity = 1;
            $page->statut_id = Statut::PUBLIE;
            $page->is_index = 1;
            $page->save();
        }
        if (Schema::hasTable('specialites_categories')) {
            $sub_menus = [];
            foreach (SpecialitesCategorie::all() as $cat) {
                /**
                 * @var SpecialitesCategorie $cat
                 */
                $sub_menus[] = new AdminMenu(['label' => $cat->nom, 'route' => 'admin_specialite_index']);
            }
            $this->addSubMenus($sub_menus);
        }
        $factory = new WorkflowsFactory(Specialite::class);
        $this->declarePublishedWorkflow($factory);
        $this->declareEnCoursWorkflow($factory);
        $this->declareArchivedWorkflow($factory);
        $this->haveGenericIndex($factory);
    }

    public function declarePublishedWorkflow(WorkflowsFactory $factory)
    {
        $factory
            //#region SPECIALITE_PUB
            ->add('Publiées', "SPECIALITE_PUB")
            ->statement('select s.* from specialites as s
                                inner join specialites_categories as sc on sc.id = s.specialites_categorie_id
                                inner Join pages as p on s.id = p.contenu_id and p.contenu_type = "Bloom\\\\CMS\\\\HPV\\\\Specialites\\\\Model\\\\Specialite"
                                where p.statut_id = ' . Statut::PUBLIE . ' order by sc.nom, s.nom')
            ->edition('admin_specialite_edit', 'Créer une spécialité')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_specialite_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_specialite_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_specialite_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Dépublier', 'admin_specialite_unpublish', 'bloomicon-admin-arrow-down-left')
                    ->addAction('Archiver', 'admin_specialite_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Nom', 'page.titre'))->canOrder(),
                    (new TableHeader('Catégorie', 'categorie.nom'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }

    public function declareEnCoursWorkflow(WorkflowsFactory $factory)
    {
        $factory
            //#region SPECIALITE_EN_COURS
            ->add('En cours de rédaction', "SPECIALITE_EN_COURS")
            ->statement('select s.* from specialites as s
                                inner Join pages as p on s.id = p.contenu_id and p.contenu_type = "Bloom\\\\CMS\\\\HPV\\\\Specialites\\\\Model\\\\Specialite"
                                where p.statut_id = ' . Statut::EN_COURS . '
                                order by p.updated_at DESC')
            ->edition('admin_specialite_edit', 'Créer une spécialité')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_specialite_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_specialite_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_specialite_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Publier', 'admin_specialite_publish', 'bloomicon-admin-arrow-up-right')
                    ->addAction('Archiver', 'admin_specialite_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Nom', 'page.titre'))->canOrder(),
                    (new TableHeader('Catégorie', 'categorie.nom'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }

    public function declareArchivedWorkflow($factory)
    {
        $factory
            //#region SPECIALITE_ARCHIVED
            ->add('Archivées', "SPECIALITE_ARCHIVED")
            ->statement('select s.* from specialites as s
                                inner Join pages as p on s.id = p.contenu_id and p.contenu_type = "Bloom\\\\CMS\\\\HPV\\\\Specialites\\\\Model\\\\Specialite"
                                where p.statut_id = ' . Statut::ARCHIVE . '
                                order by p.updated_at DESC')
            ->edition('admin_specialite_edit', 'Créer une spécialité')
            ->setAction(
                (new Actions())
                    ->addAction('Désarchiver', 'admin_specialite_unpublish')
                    ->addAction('Supprimer', 'admin_specialite_delete')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_specialite_duplicate', 'bloomicon-admin-copy')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Nom', 'page.titre'))->canOrder(),
                    (new TableHeader('Catégorie', 'categorie.nom'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))
                        ->canOrder()->haveTitle('page.derniere_modification_par.name'),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
        //#endregion
    }
}
