<?php

namespace Bloom\CMS\HPV\Specialites\Http\Controllers;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Helpers\Actions;
use Bloom\CMS\Core\Helpers\Workflow;
use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Specialites\Model\Specialite;
use Bloom\CMS\HPV\Specialites\Model\SpecialitesCategorie;
use Bloom\CMS\HPV\Specialites\SpecialitesServiceProvider;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Routing\Controller;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;

class AdminController extends Controller
{
    public function edit(Specialite $specialite)
    {
        $categories = SpecialitesCategorie::all();

        return view('Specialite::admin.edit', compact('specialite', 'categories'));
    }

    public function save(Specialite $specialite)
    {
        $statut = request('statut_id', Statut::EN_COURS);
        $specialite->nom = request('nom');
        $specialite->specialites_categorie_id = request('specialites_categorie_id');
        $specialite->contenu = request('autres_infos', '');
        $specialite_id = $specialite->id;
        $specialite->save();

        if (!$specialite_id) {
            $page = new Page();
            $page->contenu()->associate($specialite);
            $page->multiplicity = "1";
            $page->meta_titre = "";
            $page->meta_description = "";
            $page->dossier()->associate(Dossier::query()->where('name', '=', SpecialitesServiceProvider::DOSSIER_NAME)->first());
            $page->created_by = Auth::id();
        } else {
            $page = $specialite->page;
        }

        $page->titre = request('nom');
        $page->slug = request('slug');
        $page->intro = request('introduction', '');
        $page->mentions = request('mentions_legales', '');
        $page->image_opengraph = request('photo', '');
        $page->to_publish_at = request('date_pub');
        $page->to_unpublish_at = request('date_depub');
        if (request('date_pub') && Carbon::createFromFormat('Y-m-d', request('date_pub'))->isAfter(now())) {
            $statut = 2;
        }
        if ($statut == 1) {
            $page->to_publish_at = now();
        }
        $page->statut_id = $statut;
        $page->last_modified_by = Auth::id();
        $page->save();

        if ((int)$specialite->page->statut_id === Statut::PUBLIE) {
            return redirect()->route('admin_specialite_index');
        }

        $workflow = Workflow::query()->where('code', '=', 'SPECIALITE_EN_COURS')->first();

        return redirect()->route('admin_specialite_index', $workflow);
    }

    public function preview(Specialite $specialite)
    {
        return $specialite->getHandler()->single($specialite);
    }

    public function duplicate(Specialite $specialite)
    {
        $page = $specialite->page;
        $page2 = $page->replicate();
        $page2->titre .= ' - Copie';
        $page2->slug .= '-copie';
        $page2->pathname .= '-copie';
        // L’entité dupliquée prend le statut ‘en cours’
        $page2->statut_id = Statut::EN_COURS;
        $page2->to_publish_at = null;
        $page2->to_unpublish_at = null;
        $page2->save();

        $specialite2 = $specialite->replicate();
        $specialite2->nom .= ' - Copie';
        $specialite2->save();
        $page2->contenu()->associate($specialite2);
        $page2->save();
        // Ouverture de l’onglet/workflow ‘en cours’
        $workflow = Workflow::query()->where('code', '=', 'SPECIALITE_EN_COURS')->first();

        return redirect()->route('admin_specialite_index', $workflow);
    }

    public function publish(Specialite $specialite)
    {
        $specialite->page->statut_id = Statut::PUBLIE;
        $specialite->page->to_publish_at = now();
        $specialite->page->save();

        return redirect()->back();
    }

    public function unpublish(Specialite $specialite)
    {
        $specialite->page->statut_id = Statut::EN_COURS;
        $specialite->page->to_unpublish_at = now();
        $specialite->page->save();

        return redirect()->back();
    }

    public function archive(Specialite $specialite)
    {
        $specialite->page->statut_id = Statut::ARCHIVE;
        $specialite->page->to_unpublish_at = now();
        $specialite->page->save();

        return redirect()->back();
    }

    public function delete(Specialite $specialite)
    {
        $specialite->page->statut_id = Statut::SUPPRIMER;
        $specialite->page->save();

        return redirect()->back();
    }
}
