<?php

namespace Bloom\CMS\HPV\Specialites\Http\Controllers;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Helpers\Actions;
use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Specialites\Model\Specialite;
use Bloom\CMS\HPV\Specialites\Model\SpecialitesCategorie;
use Bloom\CMS\HPV\Specialites\SpecialitesServiceProvider;
use Carbon\Carbon;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;

class AdminController extends Controller
{

    public function getSubMenu(): array
    {
        return [
            'sub_menu_items' => [
                [
                    'title'  => 'Publiés',
                    'href'   => route('admin_specialite_index'),
                    'number' => Specialite::published()->count(),
                    'active' => request()->route()->getName() === 'admin_specialite_index',
                ],
                [
                    'title'  => 'En cours de rédaction',
                    'href'   => route('admin_specialite_encours'),
                    'number' => Specialite::status(Statut::EN_COURS)->count(),
                    'active' => request()->route()->getName() === 'admin_specialite_encours',
                ],
                [
                    'title'  => 'Archivés',
                    'href'   => route('admin_specialite_archived'),
                    'number' => Specialite::archived()->count(),
                    'active' => request()->route()->getName() === 'admin_specialite_archived',
                ],
            ]
        ];
    }

    public function getViewData(array $data): array
    {
        return array_merge($data, $this->getSubMenu());
    }

    public function getDefaultActions(string $publie, string $action): array
    {
        $actions = new Actions();
        $actions
            ->addAction('Modifier', 'admin_specialite_edit')
            ->addAction($publie, $action, 'bloomicon-admin-arrow-up-right')
            ->addNewTabAction('Prévisualiser', 'admin_specialite_preview');
        $sub_actions = new Actions('sub_actions');
        $sub_actions
            ->addAction('Dupliquer', 'admin_specialite_duplicate', 'bloomicon-admin-copy')
            ->addAction('Publier', 'admin_specialite_publish', 'bloomicon-admin-arrow-up-right')
            ->addAction('Archiver', 'admin_specialite_archive', 'bloomicon-admin-archive');

        return array_merge($actions->toArray(), $sub_actions->toArray());
    }

    public function index()
    {
        $specialites = Specialite::published()->get();

        return view(
            'Specialite::admin.index',
            $this->getViewData(
                compact('specialites') +
                $this->getDefaultActions('Dépublier', 'admin_specialite_unpublish')
            )
        );
    }

    public function encours()
    {
        $specialites = Specialite::status(Statut::EN_COURS)->get();

        return view(
            'Specialite::admin.index',
            $this->getViewData(
                compact('specialites') +
                $this->getDefaultActions('Publier', 'admin_specialite_publish')
            )
        );
    }

    public function archived()
    {
        $specialites = Specialite::archived()->get();
        $actions = new Actions();
        $actions
            ->addNewTabAction('Prévisualiser', 'admin_clinique_preview')
            ->addAction('Désarchiver', 'admin_specialite_unpublish');
        $sub_actions = new Actions('sub_actions');
        $sub_actions->addAction('Supprimer', 'admin_specialite_delete', 'bloomicon-admin-delete');

        return view(
            'Specialite::admin.index',
            $this->getViewData(compact('specialites') + $actions->toArray() + $sub_actions->toArray())
        );
    }

    public function edit(Specialite $specialite)
    {
        $categories = SpecialitesCategorie::all();

        return view('Specialite::admin.edit', compact('specialite', 'categories'));
    }

    public function save(Specialite $specialite)
    {
        $statut = request('statut_id', Statut::EN_COURS);
        $specialite->nom = request('nom');
        $specialite->specialites_categorie_id = request('specialites_categorie_id');
        $specialite->contenu = request('autres_infos', '');
        $specialite_id = $specialite->id;
        $specialite->save();

        if (!$specialite_id) {
            $page = new Page();
            $page->contenu()->associate($specialite);
            $page->multiplicity = "1";
            $page->meta_titre = "";
            $page->meta_description = "";
            $page->dossier()->associate(Dossier::query()->where('name', '=', SpecialitesServiceProvider::DOSSIER_NAME)->first());
            $page->created_by = Auth::id();
        } else {
            $page = $specialite->page;
        }

        $page->titre = request('nom');
        $page->slug = request('slug');
        $page->intro = request('introduction', '');
        $page->mentions = request('mentions_legales', '');
        $page->image_opengraph = request('photo', '');
        $page->to_publish_at = request('date_pub');
        $page->to_unpublish_at = request('date_depub');
        if (request('date_pub') && Carbon::createFromFormat('Y-m-d', request('date_pub'))->isAfter(now())) {
            $statut = 2;
        }
        if ($statut == 1) {
            $page->to_publish_at = now();
        }
        $page->statut_id = $statut;
        $page->last_modified_by = Auth::id();
        $page->save();

        if ((int)$specialite->page->statut_id === Statut::PUBLIE) {
            return redirect()->route('admin_specialite_index');
        }

        return redirect()->route('admin_specialite_encours');
    }

    public function preview(Specialite $specialite)
    {
        return $specialite->getHandler()->single($specialite);
    }

    public function duplicate(Specialite $specialite)
    {
        $dub = $specialite->replicate(['created_at', 'updated_at', 'created_by', 'last_modified_by']);
        $dub->nom = $specialite->nom . ' - Copie';
        $dub->save();

        $page = $dub->page->replicate([['created_at', 'updated_at', 'created_by', 'last_modified_by']]);
        $page->titre = $specialite->page->titre . '- Copie';
        $page->slug = $specialite->page->slug . "-copie";
        $page->contenu()->associate($dub);
        $page->save();

        return redirect()->back();
    }

    public function publish(Specialite $specialite)
    {
        $specialite->page->statut_id = Statut::PUBLIE;
        $specialite->page->to_publish_at = now();
        $specialite->page->save();

        return redirect()->back();
    }

    public function unpublish(Specialite $specialite)
    {
        $specialite->page->statut_id = Statut::EN_COURS;
        $specialite->page->to_unpublish_at = now();
        $specialite->page->save();

        return redirect()->back();
    }

    public function archive(Specialite $specialite)
    {
        $specialite->page->statut_id = Statut::ARCHIVE;
        $specialite->page->to_unpublish_at = now();
        $specialite->page->save();

        return redirect()->back();
    }

    public function delete(Specialite $specialite)
    {
        $specialite->page->statut_id = Statut::SUPPRIMER;
        $specialite->page->save();

        return redirect()->back();
    }
}
