<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteMeasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('site_meas'))
        {
            Schema::create('site_meas', function (Blueprint $table) {
                $table->increments('id');
                $table->bigInteger('meas_id', false, true);
                $table->integer('sites_id', false, true);
                $table->timestamps();
            });
        }
        Schema::table('meas', function (Blueprint $table) {
            $table->dropColumn('site_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_meas');
    }
}
