<?php

namespace Bloom\Cms\Sites\Helpers;

use App\User;
use Bloom\Cms\Concession\Models\Concession;
use Bloom\Cms\Sites\Models\Site;
use Bloom\Cms\Sites\Models\SiteStatut;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Auth;

class SiteHelper
{

    public static function getIndexVo(): bool
    {
        if (config('sites.multi_sites')) {
            $site = self::getCurrentSite();
            if (!is_null($site)) {
                if ($site->extraProperty('priority')) {
                    return true;
                }

                return $site->concession->index_vo === true;
            }

            return false;
        }

        return true;
    }

    public static function getCurrentSite(): ?Site
    {
        if (config('sites.multi_sites')) {
            $host = request()->getHost();

            return Site::where(function ($query) use ($host) {
                $query->where('domaine_public', '=', $host)
                    ->where('statut_id', '=', SiteStatut::EN_LIGNE);
            })
                ->orWhere('domaine_prive', '=', $host)
                ->first();
        }

        return null;
    }

    /**
     * @return ?Concession
     */
    public static function getSiteConcession(): ?Concession
    {
        $site = self::getCurrentSite();
        if (!is_null($site)) {
            return $site->concession;
        }

        return null;
    }

    public static function isCurrentSiteAllowedForUser(User $user): bool
    {
        if (config('sites.multi_sites')) {
            if ($user->super_admin) {
                return true;
            }
            $site = self::getCurrentSite();
            if ($user->groupe_site_id && $user->groupe_site_id === $site->groupe_site_id) {
                return true;
            } else {
                return self::isCurrentSiteAllowed($user);
            }
        }

        return true;
    }

    public static function isCurrentSiteAllowed($resource, $manytomany = true): bool
    {
        if (config('sites.multi_sites')) {
            if ($manytomany) {
                $sites = $resource->sites()->get();
                // aucun site sélectionné équivaut à tous les sites sélectionnés
                if (!count($sites)) {
                    return true;
                }
                foreach ($sites as $site) {
                    if (in_array(request()->getHost(), [$site->domaine_public, $site->domaine_prive])) {
                        return true;
                    }
                }
            } else {
                $site = self::getCurrentSite();
                if (!is_null($site) && $resource->site_id === $site->id) {
                    return true;
                }
            }

            return false;
        }

        return true;
    }

    public static function filter($resources, $manytomany = true)
    {
        if (!config('sites.multi_sites')) {
            return $resources;
        }

        $results = new Collection();
        foreach ($resources as $resource) {
            if (self::isCurrentSiteAllowed($resource, $manytomany)) {
                $results->add($resource);
            }
        }

        return $results;
    }

    public static function getUserAllowedSites(User $user = null)
    {
        if (config('sites.multi_sites')) {
            if (is_null($user)) {
                $user = Auth::user();
            }
            // on a 3 cas de users
            // super admin, accès à tous les sites
            if ($user->super_admin) {
                return Site::all();
            }
            // user SSO, doit avoir un groupe_site_id et a accès aux sites de ce groupe
            if (is_null($user->boss_id) && $user->groupe_site_id) {
                return Site::where('groupe_site_id', $user->groupe_site_id)->get();
            }
            // user "normal", a accès aux sites qui lui ont été attribués
            return $user->sites()->get();
        }

        return [];
    }

}
