<?php

namespace Bloom\Cms\Sites\Models;

use Bloom\Cms\Concession\Models\Concession;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * class Site
 * @package Bloom\Cms\Sites\Models
 *
 * @property string             $domaine_public
 * @property string             $domaine_prive
 * @property integer            $statut_id
 * @property string             $extra
 * @property Carbon             $dateMiseEnLigne
 * @property Carbon             $dateMiseHorsLigne
 * @property string             $code_concession
 * @property integer            $groupe_site_id
 * @property boolean            $g_analytics
 * @property boolean            $matomo
 */
class Site extends Model
{

    protected $table = 'sites';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'domaine_public',
        'domaine_prive',
        'statut_id',
        'extra',
        'dateMiseEnLigne',
        'dateMiseHorsLigne',
        'groupe_site_id',
        'g_analytics',
        'matomo',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'extra' => 'array',
    ];

    public function extraProperty($property = null)
    {
        if (!is_null($this->extra) && array_key_exists($property, $this->extra)) {
            return $this->extra[$property];
        }

        return null;
    }

    public function concession()
    {
        return $this->hasOne(Concession::class);
    }
}
