<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Sante;

use Bloom\Cms\Configuration\Facade\Site;
use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Sante\Model\Sante;
use Illuminate\Database\Eloquent\Relations\Relation;

class CmsSanteServiceProvider extends BloomProvider
{
    protected $nom = "Produits de Santé";
    protected $code = "sante";
    protected $has_admin = true;
    protected $icons = "heart";

    public function boot(): void
    {
        parent::boot();
        // Déclaration contenu

        Site::getConfig('Largeur image santé', 'VIGNETTE_SANTE_IMG_L', 'Santé', '2000', '\d+', 'La largeur doit être un chiffre', false);
        Site::getConfig('Largeur image santé', 'VIGNETTE_SANTE_IMG_H', 'Santé', '1300', '\d+', 'La largeur doit être un chiffre', false);

        Relation::morphMap([
            'santes' => Sante::class,
        ]);
        Page::declareContenu('santes');

        $this->publishes([
            dirname(__DIR__) . '/public/build' => public_path('/vendor/cms-module-sante')
        ], 'assets');
    }
}
