<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

use Illuminate\Support\Facades\Route;

Route::group(['prefix' => config('app.admin'), 'middleware' => ['auth'], 'namespace' => 'Bloom\CMS\Modules\Sante\Http\Controllers'], function () {
    Route::group(['prefix' => 'santes'], function () {
        Route::get('/', 'AdminController@index')->name('admin_sante_index');
        Route::get('/encours', 'AdminController@encours')->name('admin_sante_encours');
        Route::get('/archived', 'AdminController@archived')->name('admin_sante_archived');
        Route::get('/edit/{sante?}', 'AdminController@edit')->name('admin_sante_edit');
        Route::post('/edit/{sante?}', 'AdminController@save')->name('admin_sante_save');
        Route::get('/{sante}/preview', 'AdminController@preview')->name('admin_sante_preview');
        Route::get('/{sante}/publish', 'AdminController@publish')->name('admin_sante_publish');
        Route::get('/{sante}/unpublish', 'AdminController@unpublish')->name('admin_sante_unpublish');
        Route::get('/{sante}/archive', 'AdminController@archive')->name('admin_sante_archive');
        Route::get('/{sante}/delete', 'AdminController@delete')->name('admin_sante_delete');
    });
});