const slugify = require('slugify');

let form;
window.publishAndSubmit = () => {
    form = $('.main form');
    // Si le form est pas présent c'est que jean michel click avant la fin du chargement de la page
    if (form === undefined) {
        document.addEventListener('readystatechange', publishAndSubmit);
    }

    let statut = form.find('input[name="statut_id"]').first();

    if (statut.length) {
        statut.val('1');
    } else {
        form.append($('<input name="statut_id" value="1" type="hidden">'));
    }

    form.submit();
}

document.addEventListener("readystatechange", () => {
    /**
     * Block / Unblock link_choice
     * @param {boolean} state
     */

    function lienChange(state, el = null) {
        let section = el.attr('id').split('lien')[1],
            element = el.attr('name');

        $('[name="link_choice_' + element + '"]').prop("disabled", !state);
        $('[name="' + element + '_libelle"]').prop("disabled", !state);
        $('.wrapper' + section).show();
        if (!state) {
            $('[name="link_choice_' + element + '"]').prop("checked", false);
            $('[name="' + element + '_libelle"]').val('');
            $('[name="' + element + '_href"]').val('');
            $('[name="' + element + '_page_id"]').val('');
            $('.wrapper' + section).hide();
        }
        $('[name="link_choice_' + element + '"]').each(function() {
            let $el = $(this);
            switch ($el.val()) {
                case 'interne':
                    $('[id="' + element + '_page_id"]').prop('disabled', !$el.is(':checked'));
                    break;
                case 'externe':
                    $('[id="' + element + '_href"]').prop('disabled', !$el.is(':checked'));
            }
        });
    }

    function niveauChange(state, el = null) {
        let section = el.attr('id').split('niveau')[1],
            element = el.attr('name');
        $('.wrapper' + section + ' input').prop('disabled', !state);
        $('.wrapper' + section + ' textarea').prop('disabled', !state);
        if (CKEDITOR.instances[element + '_details'] != undefined && CKEDITOR.instances[element + '_details'].loaded == true) {
            CKEDITOR.instances[element + '_details'].setReadOnly(false);
        }
        $('.wrapper' + section).show();

        if (!state) {
            $('.wrapper' + section).hide();
            $('.wrapper' + section + ' input').val('');
            $('.wrapper' + section + ' textarea').val('');
            if (CKEDITOR.instances[element + '_details'] != undefined && CKEDITOR.instances[element + '_details'].loaded == true) {
                CKEDITOR.instances[element + '_details'].setData('');
                CKEDITOR.instances[element + '_details'].setReadOnly(true);
            }
        }
    }

    function exempleChange(state, el = null) {
        let section = el.attr('id').split('example')[1],
            element = el.attr('name');
        $('.wrapper' + section + ' input').prop('disabled', !state);
        $('.wrapper' + section + ' textarea').prop('disabled', !state);
        if (CKEDITOR.instances[element + '_details'] != undefined && CKEDITOR.instances[element + '_details'].loaded == true) {
            CKEDITOR.instances[element + '_details'].setReadOnly(false);
        }
        $('.wrapper' + section).show();

        if (!state) {
            $('.wrapper' + section).hide();
            $('.wrapper' + section + ' input').val('');
            $('.wrapper' + section + ' textarea').val('');
            if (CKEDITOR.instances[element + '_details'] != undefined && CKEDITOR.instances[element + '_details'].loaded == true) {
                CKEDITOR.instances[element + '_details'].setData('');
                CKEDITOR.instances[element + '_details'].setReadOnly(true);
            }
        }
    }

    form = $('.main form');
    let liens = $('[id^="lien"][data-element="switch"]'),
        niveaux = $('[id^="niveau"][data-element="switch"]'),
        exemples = $('[id^="example"][data-element="switch"]');

    if (liens.length > 0) {
        for (let i = liens.length - 1; i >= 0; i--) {
            let section = liens[i].id.split('lien')[1],
                element = liens[i].name;
            $('.wrapper' + section).hide();
            $(liens[i]).change(function (e) {
                lienChange($(e.target).is(':checked'), $(e.target));
            });
            lienChange($(liens[i]).is(':checked'), $(liens[i]));
            $('[name="link_choice_' + element + '"]').change(function(e) {
                let choice = e.currentTarget.value;

                if (choice.toLowerCase() == 'interne') {
                    $('[name="' + element + '_page_id"]').prop('disabled', false);
                    $('[name="' + element + '_href"]').prop('disabled', true);
                    $('[name="' + element + '_href"]').val('');
                }

                if (choice.toLowerCase() == 'externe') {
                    $('[name="' + element + '_page_id"]').prop('disabled', true);
                    $('[name="' + element + '_page_id"]').val('');
                    $('[name="' + element + '_href"]').prop('disabled', false);
                }
            });
        }
    }

    if (niveaux.length > 0) {
        for (let i = niveaux.length - 1; i >= 0; i--) {
            let section = niveaux[i].id.split('niveau')[1];
            $('.wrapper' + section).hide();
            $(niveaux[i]).change(function (e) {
                niveauChange($(e.target).is(':checked'), $(e.target));
            });
            niveauChange($(niveaux[i]).is(':checked'), $(niveaux[i]));
        }
    }

    if (exemples.length > 0) {
        for (let i = exemples.length - 1; i >= 0; i--) {
            let section = exemples[i].id.split('example')[1];
            $('.wrapper' + section).hide();
            $(exemples[i]).change(function (e) {
                exempleChange($(e.target).is(':checked'), $(e.target));
            });
            exempleChange($(exemples[i]).is(':checked'), $(exemples[i]));
        }
    }

    $('#titre').on('input', function (e) {
        $('#slug').val(slugify(e.target.value, {strict: true, remove: /\s[!.?]/g}))
    });
});