@extends('bloom.layout.admin')

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>Produits de Santé</h1>

            <a href="{{ route('admin_sante_edit') }}" class="btn btn-grisclair5 btn-primary">
                Créer un produit
            </a>
        </div>

        <div class="content">
            <ul class="list-nav-articles nav nav-pills mb-3">
                @foreach($sub_menu_items as $item)
                    <li class="nav-item">
                        <a href="{{ $item->href }}"{{ $item->active ? 'class="active"' : '' }}>
                            <span class="text">{{ $item->title }}</span>
                            <span class="badge badge-primary badge-pill">{{ $item->number }}</span>
                        </a>
                    </li>
                @endforeach
            </ul>

            <div class="table-responsive">
                <table class="table table-admin">
                    <thead>
                    <tr>
                        <th scope="col">Vignette</th>
                        <th scope="col">
                            <a class="order-me @if($order->item === $id) sort-{{ $order->order }} @endif"
                               href="?orderBy=id&order=@if($order->item === $id){{ $order->order === 'asc' ? 'desc' : 'asc' }} @else asc @endif">
                                <span class="text">Id</span>
                                <span class="sort">
                                    <span class="fa fa-sort-asc" aria-hidden="true"></span>
                                    <span class="fa fa-sort-desc" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col">

                            <a class="order-me @if($order->item === $page->titre) sort-{{ $order->order }}@endif"
                               href="?orderBy=$page->titre&order=@if($order->item === $page->titre){{ $order->order === 'asc' ? 'desc' : 'asc' }} @else asc @endif">
                                <span class="text">Titre</span>
                                <span class="sort">
                                    <span class="fa fa-sort-asc" aria-hidden="true"></span>
                                    <span class="fa fa-sort-desc" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col">Chemin archi</th>
                        <th scope="col">
                            <a class="order-me @if($order->item === $created_at) sort-{{ $order->order }} @endif"
                               href="?orderBy=created_at&order=@if($order->item === $created_at){{ $order->order === 'asc' ? 'desc' : 'asc' }} @else asc @endif">
                                <span class="text">Créé le</span>
                                <span class="sort">
                                    <span class="fa fa-sort-asc" aria-hidden="true"></span>
                                    <span class="fa fa-sort-desc" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col">
                            <a class="order-me @if($order->item === $modified_at) sort-{{ $order->order }} @endif"
                               href="?orderBy=modified_at&order=@if($order->item === $modified_at){{ $order->order === 'asc' ? 'desc' : 'asc' }} @else asc @endif">
                                <span class="text">Modifié le</span>
                                <span class="sort">
                                    <span class="fa fa-sort-asc" aria-hidden="true"></span>
                                    <span class="fa fa-sort-desc" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col">
                            <a class="order-me" href="javascript:void(0);">
                                <span class="text">
                                    Dates de<br>
                                    publication
                                </span>
                                <span class="sort">
                                    <span class="fa fa-sort-asc" aria-hidden="true"></span>
                                    <span class="fa fa-sort-desc" aria-hidden="true"></span>
                                </span>
                            </a>
                        </th>
                        <th scope="col" colspan="2"></th>
                    </tr>
                    </thead>
                    <tbody>
                    @if(count($santes) > 0)
                        @foreach($santes as $sante)
                            @php($page=$sante->page)
                            <tr>
                                <td><img src="{{ $page->image_opengraph }}" alt="" class="img-fluid"></td>
                                <td>{{ $sante->id }}</td>
                                <td>{{ $page->titre }}</td>
                                <td>
                                    @if($page->dossier)
                                        {{ str_replace('/', ' > ', $page->dossier->full_pathname) }}
                                    @endif
                                </td>
                                <td>
                                    <span class="tooltip-elmt d-inline-block" data-toggle="tooltip"
                                          data-placement="bottom" title="{{ $page->cree_par->name }}">
                                        {{ Carbon::parse($page->created_at)->format('d/m/Y') }}
                                    </span>
                                </td>
                                <td>
                                    <span class="tooltip-elmt d-inline-block" data-toggle="tooltip"
                                          data-placement="bottom" title="{{ $page->deriere_modification_par->name }}">
                                        {{ Carbon::parse($page->updated_at)->format('d/m/Y') }}
                                    </span>
                                </td>
                                <td>
                                    @if(!is_null($page->to_publish_at))
                                        <span class="tooltip-elmt d-inline-block">
                                            du {{ Carbon::parse($page->to_publish_at)->format('d/m/Y') }}<br>
                                            au {{ Carbon::parse($page->to_unpublish_at)->format('d/m/Y') }}
                                        </span>
                                    @endif
                                </td>
                                <td class="btn-group-cta btn-group-sm text-right">
                                    <x-action-list
                                            :actions="$actions"
                                            :item="$sante"
                                    />
                                </td>
                                @if($count($sub_actions) > 0)
                                    <td>
                                        <x-action-dropDown
                                                :id="'dropdownMenu0' . $loop->index"
                                                :actions="$sub_actions"
                                                :item="$sante"
                                        />
                                    </td>
                                @endif
                            </tr>
                        @endforeach
                    @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection